<?php
/**
 * WPDirectoryUpdates Plugin Updater Class
 * isplay plugin auto update notification in plugin section on backend
 * new WPUpdatesPluginUpdater( '//wp-updates.com/api/1/plugin', 1, plugin_basename(__FILE__) );
 *
 * @package WordPress
 * @subpackage Tevolution-LocationManager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Location_Manager_Updates' ) ) {
	/**
	 * WP_Location_Manager_Updates Plugin Updater Class
	 */
	class WP_Location_Manager_Updates {
		/**
		 * Api url
		 *
		 * @var url $api_url 			Api url for tevolution-directory plugin.
		 */
		var $api_url;
		/**
		 * Plugin Path
		 *
		 * @var url $plugin_path 		Tevolution-directory plugin path.
		 */
		var $plugin_path;
		/**
		 * Plugin Slug
		 *
		 * @var url $plugin_slug 		Tevolution-directory plugin slug.
		 */
		var $plugin_slug = TEVOLUTION_LOCATION_SLUG;
		/**
		 * Plugin Version
		 *
		 * @var url $plugin_version 	Tevolution-directory plugin version.
		 */
		var $plugin_version = TEVOLUTION_LOCATION_VERSION;
		/**
		 * Update plugin custructor.
		 *
		 * @param url $api_url 			Api url for tevolution-directory plugin.
		 * @param url $plugin_path 		Tevolution-directory plugin path.
		 */
		function __construct( $api_url, $plugin_path ) {
			$plugin_path = plugin_dir_path( __FILE__ );
			$plugin_file = $plugin_path . 'location-manager.php';
			$plugin_data = get_plugin_data( $plugin_file, $markup = true, $translate = true );
			$plugin_version = $plugin_data['Version'];
			$this->api_url = $api_url;
			$this->plugin_path = $plugin_path;

			if ( strstr( $plugin_path, '/' ) ) {  list ($t1, $t2) = explode( '/', $plugin_path );
			} else { $t2 = $plugin_path;
			}

			add_filter( 'pre_set_site_transient_update_plugins', array( &$this, 'location_manager_check_for_update' ) );
			add_filter( 'plugins_api', array( &$this, 'location_manager_plugin_api_call' ), 10, 3 );

			if ( is_network_admin() || ! is_multisite() ) {
				add_action( 'after_plugin_row_' . TEVOLUTION_LOCATION_SLUG, array( &$this, 'location_manager_plugin_row' ) ,10,3 );
			}
		}


		/**
		 * Add action for set the auto update for tevolution plugin
		 * Function Name: tevolution_plugin_row
		 * Return : Display the plugin new version update message
		 *
		 * @param string $plugin_file 				Plugin main file path.
		 * @param array  $plugin_data 				Plugin related data.
		 * @param string $status 					Plugin stauts updated or not.
		 */
		function location_manager_plugin_row( $plugin_file, $plugin_data, $status ) {
			/*check the remote version*/
			global $plugin_response;
			$current = get_site_transient( 'update_plugins' );
			$r = @$current->response[ $plugin_file ];
			$new_version_data= get_option($this->plugin_slug . '_theme_version');
			$remote_version = $new_version_data[$this->plugin_slug]['new_version'];
			if ( version_compare( $this->plugin_version , $remote_version, '<' ) ) {
				$new_version = version_compare( $this->plugin_version , $remote_version, '<' ) ? __( 'There is a new version of Tevolution-Location Manager plugin available ', 'templatic-admin' )  : '';

				$ajax_url = esc_url( add_query_arg( array(
					'slug' => 'location-manager',
					'action' => 'location-manager',
					'_ajax_nonce' => esc_attr( wp_create_nonce( 'location-manager' ) ),
					'TB_iframe' => true,
					'width' => 500,
					'height' => 400,
				), admin_url( 'admin-ajax.php' ) ) );
				$file = 'Tevolution-LocationManager/location-manager.php';
				$download = wp_nonce_url( self_admin_url( 'update.php?action=upgrade-plugin&plugin=' ) . $file, 'upgrade-plugin_' . $file );
				echo '<tr class="plugin-update-tr active templatic-updates" id="-update"><td colspan="3" class="plugin-update colspanchange"><div class="update-message notice inline notice-warning notice-alt"><p>' . wp_kses_post( $new_version ) . ' <a href="' . esc_url( $ajax_url ) . '" class="thickbox" title="Templatic Locatron Manager Update">' . esc_html__( 'update now','templatic' ) . '</a></p></div></td></tr>';

			}
		}
		/**
		 * Add action for set the auto update for tevolution plugin. Display the plugin new version update message
		 *
		 * @param string $transient 				Transient to check update of plugin exists or not.
		 */
		function location_manager_check_for_update( $transient ) {

			global $plugin_response,$wp_version;
			
			$current = get_site_transient( 'update_plugins' );
			$r = @$current->response[ $plugin_file ];
			$new_version_data= get_option($this->plugin_slug . '_theme_version');
			$remote_version = $new_version_data[$this->plugin_slug]['new_version'];
			foreach( $transient->response as $key=>$value)
			{
				if($key=='Tevolution-LocationManager/location-manager.php')
				{
					if ( version_compare( $this->plugin_version , $remote_version, '==' ) ) 
					{
						return false;
					}
				}
			}

			if ( empty( $transient->checked ) ) {
				 /* return $transient; */ // to check the empty transient
			}
			$request_args = array(
				'slug' => $this->plugin_slug,
				'version' => $this->plugin_version,
				);
			$request_string = $this->location_manager_prepare_request( 'templatic_plugin_update', $request_args );

			$raw_response = wp_remote_post( $this->api_url, array(
															'method' => 'POST',
															'timeout'     => 45,
															'body' => $request_string) );
			$response = null;
			if ( ! is_wp_error( $raw_response ) && ($raw_response['response']['code'] == 200) ) {
				$response = json_decode( $raw_response['body'] );
			}

			if ( ! empty( $response ) ) {/* Feed the update data into WP updater*/
				$transient->response[ $this->plugin_slug ] = $response;
				$plugin_response[ $this->plugin_slug ] = (array) $response;
				update_option( $this->plugin_slug . '_theme_version',$plugin_response );
			}
			return $transient;
		}
		/**
		 * Allows a plugin to override the WordPress.org Plugin Install API entirely.
		 * This function call for get the plugin update notification if they get the error from there then display plugins api failed and its correct then return
		 * request object
		 * Please ensure that an object is returned.
		 *
		 * @param string $def 				Defination.
		 * @param string $action 			Action to perform.
		 * @param array  $args 				Arguments.
		 */
		function location_manager_plugin_api_call( $def, $action, $args ) {
			if ( ! isset( $args->slug ) || $args->slug != $this->plugin_slug ) { return $def;
			}

			$plugin_info = get_site_transient( 'update_plugins' );
			$request_args = array(
				'slug' => $this->plugin_slug,
				'version' => (isset( $plugin_info->checked )) ? $plugin_info->checked[ $this->plugin_path ] : 0 /* Current version*/,
				);

			$request_string = $this->location_manager_prepare_request( $action, $request_args );
			$raw_response = wp_remote_post( $this->api_url, $request_string );

			if ( is_wp_error( $raw_response ) ) {
				$res = new WP_Error( 'plugins_api_failed', __( 'An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>', 'templatic-admin' ), $raw_response->get_error_message() );
			} else {
				$res = json_decode( $raw_response['body'] );
				if ( $res === false ) {
					$res = new WP_Error( 'plugins_api_failed', __( 'An unknown error occurred', 'templatic-admin' ), $raw_response['body'] );
				}
			}
			return $res;
		}
		/**
		 * Create auto update request array.
		 *
		 * @param string $action 			Action to perform.
		 * @param array  $args 				Arguments.
		 */
		function location_manager_prepare_request( $action, $args ) {
			global $wp_version;

			return array(			
				'action' => $action,
				'request' => serialize( $args ),
				'api-key' => md5( home_url( ) ),			
				'user-agent' => 'WordPress/' . $wp_version . '; ' . home_url(),
				);
		}


	}
} // End if().
