<?php
/**
 * Insert default custom feilds ans its related option.
 *
 * @package WordPress
 * @subpackage Tevolution
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_query, $wpdb;
/**-- conditions for activation Custom Fields --**/

if ( (isset( $_REQUEST['activated'] ) && $_REQUEST['activated'] == 'custom_fields_templates' ) && (isset( $_REQUEST['true'] ) && $_REQUEST['true'] == 1) || (isset( $_REQUEST['activated'] ) && $_REQUEST['activated'] == 'true' ) ) {
	update_option( 'custom_fields_templates', 'Active' );
	$templatic_settings[] = get_option( 'templatic_settings' );

	if ( ! isset( $templatic_settings['templatic-category_custom_fields'] ) && $templatic_settings['templatic-category_custom_fields'] == '' ) {
		$tmpdata['templatic-category_custom_fields'] = 'No';
	} else { 		$tmpdata['templatic-category_custom_fields'] = $templatic_settings['templatic-category_custom_fields'];
	}

	update_option( 'templatic_settings', array_merge( $templatic_settings, $tmpdata ) );

} elseif ( (isset( $_REQUEST['deactivate'] ) && $_REQUEST['deactivate'] == 'custom_fields_templates' ) && (isset( $_REQUEST['true'] ) && $_REQUEST['true'] == 0 ) ) {
	delete_option( 'custom_fields_templates' );
}
/**-- coding to add sub menu under main menu--**/

/* Files related to monetization */

add_filter( 'set-screen-option', 'custom_fields_set_screen_option', 10, 3 );

if ( file_exists( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/tevolution_custom_fields_functions.php' ) ) {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/tevolution_custom_fields_functions.php' );
}
if ( file_exists( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/custom_fields_preview_function.php' ) ) {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/custom_fields_preview_function.php' );
}
if ( file_exists( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/custom_fields_function.php' ) ) {
	if ( is_admin() && isset( $_SERVER['REQUEST_URI'] ) && strstr( wp_kses_post( wp_unslash( $_SERVER['REQUEST_URI'] ) ), '/wp-admin/' ) ) {
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_custom_fuctions.php' );
	} else {
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/custom_fields_function.php' );
	}
}

if ( file_exists( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_post_type_custom_fields_table.php' ) && is_admin() ) {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_post_type_custom_fields_table.php' );
}

if ( file_exists( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/language.php' ) ) {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/language.php' );
}

add_filter( 'body_class', 'remove_admin_bar_onpreview', 10,2 );/* call body class for remove admin bar */
add_action( 'init', 'custom_fields_preview' ,11 );
add_action( 'admin_init', 'create_default_wordpress_customfields' );

add_action( 'templatic_general_setting_data', 'post_page_setting_data' );/* call general setting data */

add_action( 'admin_init', 'post_expire_session_table_create' );
add_action( 'admin_notices', 'tevolution_custom_fields_notice', 30 );
add_action( 'admin_notices', 'templatic_site_info_tracking_notice', 30 );

/* Set the file extension for allown only image/picture file extension in upload file*/
global $extension_file;
$extension_file = array( '.jpg', '.JPG', 'jpeg', 'JPEG', '.png', '.PNG', '.gif', '.GIF', '.jpe', '.JPE', '.zip', '.ZIP', '.pdf' );

/* set screen option for custom field*/
function custom_fields_set_screen_option( $status, $option, $value ) {
	if ( 'custom_fields_per_page' == $option ) { return $value;
	}
}

/*
 * unset the admin-bar class on preview and success page
 */
function remove_admin_bar_onpreview( $classes, $class ) {

	if ( (isset( $_REQUEST['page'] ) && ( $_REQUEST['page'] == 'preview' || $_REQUEST['page'] == 'success' ) )  || (isset( $_REQUEST['ptype'] ) && $_REQUEST['ptype'] == 'return' ) ) {
		if ( ( $key = array_search( 'admin-bar', $classes ) ) !== false ) {
			unset( $classes[ $key ] );
		}
	}
	return $classes;
}


/* include the success page for different payment gateway */
function custom_fields_preview() {
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'payment' ) {
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/post_upgrade_payment.php' );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'paynow' ) {
		global $_wp_additional_image_sizes;
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/custom_fields_paynow.php' );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'upgradenow' ) {
		global $_wp_additional_image_sizes;
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/post_upgrade_pay.php' );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'success' ) {
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/success.php' );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'paypal_pro_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-paypal_pro/includes/paypal_pro_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'authorizedotnet_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-authorizedotnet/includes/authorizedotnet_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'googlecheckout_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-googlecheckout/includes/googlecheckout_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'worldpay_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-worldpay/includes/worldpay_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'eway_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-eway/includes/eway_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'ebay_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-ebay/includes/ebay_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'ebs_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-ebs/includes/ebs_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'psigate_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-psigate/includes/psigate_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == '2co_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-2co/includes/2co_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'stripe_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-stripe/includes/stripe_success.php';
		include( $dir );
		exit;
	}

	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'braintree_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-Braintree/includes/braintree_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'inspire_commerce_success' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-InspireCommerce/includes/inspire_commerce_success.php';
		include( $dir );
		exit;
	}
	if ( isset( $_GET['stripe-listener'] ) && $_GET['stripe-listener'] == 'recurring' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-stripe/includes/stripe_listener.php';
		include( $dir );
		exit;
	}
	if ( isset( $_REQUEST['pmethod'] ) && $_REQUEST['pmethod'] == 'paypal_express_checkout' ) {
		$dir = get_tmpl_plugin_directory() . 'Tevolution-paypal_express_checkout/includes/paypal_express_checkout_success.php';
		include( $dir );
		exit;
	}
}
/* Insert wordpress default fields in posts table when plugin activated */
function create_default_wordpress_customfields() {
	/*Reset tevolution Custom Fields */
	if ( isset( $_POST['reset_custom_fields'] ) && (isset( $_POST['custom_reset'] ) && $_POST['custom_reset'] == 1 ) ) {
		update_option( 'tmpl_default_fields_inserted', '' );
	}

	global $wpdb, $pagenow;
	if ( ( $pagenow == 'plugins.php' || $pagenow == 'themes.php' || (isset( $_REQUEST['page'] ) && ( $_REQUEST['page'] == 'custom_setup' || ( isset( $_REQUEST['ctab'] ) && $_REQUEST['ctab'] == 'custom_fields' ) ) ) ) ) {

		$args = array(
			'public' => true,
			'label' => 'Fields',
			);
		register_post_type( 'custom_fields', $args );

		/* this option will set after default fields inserted */

		update_option( 'tmpl_default_fields_inserted', '1' );

		/*Reset tevolution Custom Fields */
		if ( isset( $_POST['reset_custom_fields'] ) && (isset( $_POST['custom_reset'] ) && $_POST['custom_reset'] == 1 ) ) {
			$args = array(
			'post_type'   => 'custom_fields',
				'posts_per_page' => -1,
				'post_status'  => array( 'publish' ),
				'order'     => 'ASC',
				);
			$custom_field = new WP_Query( $args );
			if ( $custom_field ) :
				while ( $custom_field->have_posts() ) : $custom_field->the_post();
					wp_delete_post( get_the_ID(), true );
			endwhile;
			endif;

		}

		/* Here You have to pass "$exclude_post_types" same variable in other plugins as well.
		*/
		$exclude_post_type = apply_filters( 'reset_exclude_post_types', array() );
		$cus_pos_type = get_option( 'templatic_custom_post' );
		$post_type_arr = 'post,';
		$heading_post_type_arr = 'post,';
		if ( $cus_pos_type && count( $cus_pos_type ) > 0 ) {
			foreach ( $cus_pos_type as $key => $_cus_pos_type ) {
				if ( ! empty( $exclude_post_type ) ) {
					if ( ! in_array( $key, $exclude_post_type ) ) {
						$post_type_arr .= $key . ',';
					}
				} else {
					$post_type_arr .= $key . ',';
				}
				$heading_post_type_arr .= $key . ',';
			}
		}
		$post_type_arr = substr( $post_type_arr,0,-1 );
		$heading_post_type_arr = substr( $heading_post_type_arr,0,-1 );

		/* Insert Post heading type into posts */
		$taxonomy_name = array();
		$taxonomy_name = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_title = '[#taxonomy_name#]' and $wpdb->posts.post_type = 'custom_fields'" );
		if ($taxonomy_name->ID ==''  ) {
			$my_post = array(
				'post_title'  => '[#taxonomy_name#]',
				'post_content' => 'It is a default heading type used for grouping certain custom fields together under the same particular heading at front end. (e.g. place information, event information etc.)',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'basic_inf',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'	   => $heading_post_type_arr,
				'ctype'	     => 'heading_type',
				'site_title'	 => '[#taxonomy_name#]',
				'htmlvar_name'  => 'basic_inf',
				'sort_order' 	 => '1',
				'post_sort_order' 	 => '1',
				'is_active' 	 => '1',
				'show_on_page'  => 'user_side',
				'show_on_detail' => '0',
				'show_in_column' => '0',
				'is_search'    => ' 0',
				'is_edit' 	   => 'true',
				'is_submit_field' => '1',
				'heading_type'  => '[#taxonomy_name#]',
				);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}

			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . $_ex_post_type . '' , 'all' );
			}
		} else {
			/* Reset if user change this type */
			update_post_meta( $taxonomy_name->ID, 'ctype', 'heading_type' );

			$post_type = get_post_meta( $taxonomy_name->ID, 'post_type', true );
			if ( ! strstr( $post_type, 'post' ) ) {
				update_post_meta( $taxonomy_name->ID, 'post_type', $post_type . ', post' );
			}

			update_post_meta( $taxonomy_name->ID, 'post_type_post', 'post' );
			update_post_meta( $taxonomy_name->ID, 'taxonomy_type_category', 'category' );

			if ( get_post_meta( $taxonomy_name->ID, 'post_sort_order', true ) ) {
				update_post_meta( $taxonomy_name->ID, 'post_sort_order', get_post_meta( $taxonomy_name->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $taxonomy_name->ID, 'post_sort_order', 1 );
			}
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $taxonomy_name->ID, $el_type = 'post_custom_fields', $taxonomy_name->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $taxonomy_name->ID, 'custom_fields' );
				}
			}
		}// End if().

		/* Insert Post Category into posts */
		$post_category = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'category' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( $post_category->ID =='') {
			$my_post = array(
				'post_title'  => 'Post Category',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'category',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'     => $post_type_arr,
				'ctype'       => 'post_categories',
				'htmlvar_name'    => 'category',
				'sort_order'     => '1',
				'is_active'     => '1',
				'is_require'     => '1',
				'show_on_page'    => 'user_side',
				'is_edit'      => 'true',
				'show_on_detail'   => '1',
				'show_on_listing'  => '0',
				'show_in_column'   => '0',
				'is_submit_field'  => '1',
				'is_search'     => '0',
				'field_require_desc' => __( 'Please Select Category', 'templatic' ),
				'validation_type'  => 'require',
				'heading_type'    => '[#taxonomy_name#]',
				);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}
			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . $_ex_post_type . '' , 'all' );
				add_post_meta( $post_id, 'post_sort_order' , '1' );
				add_post_meta( $post_id, 'post_heading_type' , '[#taxonomy_name#]' );
			}
		} else {
			/* Set always active post if user deactive */
			update_post_meta( $post_category->ID, 'is_active', '1' );

			$post_type = get_post_meta( $post_category->ID, 'post_type', true );
			if ( ! strstr( $post_type, 'post' ) ) {
				update_post_meta( $post_category->ID, 'post_type', $post_type . ', post' );
			}

			update_post_meta( $post_category->ID, 'post_type_post', 'post' );
			update_post_meta( $post_category->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( $post_category->ID, 'show_in_post_search', '1' );
			update_post_meta( $post_category->ID, 'show_on_detail', '1' );
			if ( get_post_meta( $post_category->ID, 'post_sort_order', true ) ) {
				update_post_meta( $post_category->ID, 'post_sort_order', get_post_meta( $post_category->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $post_category->ID, 'post_sort_order', 1 );
			}

			if ( get_post_meta( $post_category->ID, 'post_heading_type', true ) ) {
				update_post_meta( $post_category->ID, 'post_heading_type', get_post_meta( $post_category->ID, 'post_heading_type', true ) );
			} else {
				update_post_meta( $post_category->ID, 'post_heading_type', '[#taxonomy_name#]' );
			}

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_category->ID, $el_type = 'post_custom_fields', $post_category->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_category->ID, 'custom_fields' );
				}
			}
		}// End if().
		/* Finish The category custom field */

		/* Insert Post title into posts */
		$post_title = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'post_title' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( $post_title->ID == '') {
			$my_post = array(
				'post_title'  => 'Post Title',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'post_title',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'     => $post_type_arr,
				'ctype'       => 'text',
				'htmlvar_name'    => 'post_title',
				'sort_order'     => '2',
				'is_active'     => '1',
				'is_require'     => '1',
				'show_on_page'    => 'user_side',
				'is_edit'      => 'true',
				'show_on_detail'   => '0',
				'show_on_success'  => '1',
				'show_on_listing'  => '1',
				'show_in_column'   => '0',
				'is_search'     => '0',
				'is_submit_field'  => '1',
				'field_require_desc' => __( 'Please Enter title', 'templatic' ),
				'validation_type'  => 'require',
				'heading_type'    => '[#taxonomy_name#]',
				);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}
			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . $_ex_post_type . '' , 'all' );
			}
		} else {
			/* Set always active post title id user deactive */
			update_post_meta( $post_title->ID, 'is_active', '1' );

			$post_type = get_post_meta( $post_title->ID, 'post_type', true );

			update_post_meta( $post_title->ID, 'post_type_post', 'post' );
			update_post_meta( $post_title->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( $post_title->ID, 'show_in_post_search', '1' );

			if ( get_post_meta( $post_title->ID, 'post_sort_order', true ) ) {
				update_post_meta( $post_title->ID, 'post_sort_order', get_post_meta( $post_title->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $post_title->ID, 'post_sort_order', 2 );
			}

			if ( get_post_meta( $post_title->ID, 'post_heading_type', true ) ) {
				update_post_meta( $post_title->ID, 'post_heading_type', get_post_meta( $post_title->ID, 'post_heading_type', true ) );
			} else {
				update_post_meta( $post_title->ID, 'post_heading_type', '[#taxonomy_name#]' );
			}
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_title->ID, $el_type = 'post_custom_fields', $post_title->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_title->ID, 'custom_fields' );
				}
			}
		}// End if().
		/* Finish the post title custom fields */

		/* Insert Post content into posts */
		$post_content = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'post_content' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( $post_content->ID =='' ) {
			$my_post = array(
				'post_title' => 'Post Content',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'post_content',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'     => $post_type_arr,
				'ctype'       => 'texteditor',
				'show_in_column'   => '0',
				'htmlvar_name'    => 'post_content',
				'sort_order'     => '3',
				'is_active'     => '1',
				'is_require'     => '1',
				'show_on_page'    => 'user_side',
				'is_edit'      => 'true',
				'show_on_detail'   => '1',
				'show_on_listing'  => '1',
				'show_in_column'   => '0',
				'is_search'     => '0',
				'is_submit_field'  => '1',
				'field_require_desc' => __( 'Please Enter content', 'templatic' ),
				'validation_type'  => 'require',
				'heading_type'    => '[#taxonomy_name#]',
				'listing_heading_type' => '[#taxonomy_name#]',
			);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}

			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . $_ex_post_type . '' , 'all' );
			}
		} else {
			/* Set always active post if user deactive */
			update_post_meta( $post_content->ID, 'is_active', '1' );

			$post_type = get_post_meta( $post_content->ID, 'post_type', true );

			update_post_meta( $post_content->ID, 'post_type_post', 'post' );
			update_post_meta( $post_content->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( $post_content->ID, 'show_in_post_search', '1' );

			if ( get_post_meta( $post_content->ID, 'post_sort_order', true ) ) {
				update_post_meta( $post_content->ID, 'post_sort_order', get_post_meta( $post_content->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $post_content->ID, 'post_sort_order', 3 );
			}

			if ( get_post_meta( $post_content->ID, 'post_heading_type', true ) ) {
				update_post_meta( $post_content->ID, 'post_heading_type', get_post_meta( $post_content->ID, 'post_heading_type', true ) );
			} else {
				update_post_meta( $post_content->ID, 'post_heading_type', '[#taxonomy_name#]' );
			}

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_content->ID, $el_type = 'post_custom_fields', $post_content->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_content->ID, 'custom_fields' );
				}
			}
		}// End if().
		/* Finish the post content custom field */

		/* Insert Post excerpt into posts */
		$post_content = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'post_excerpt' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( $post_content->ID == '' ) {
			$my_post = array(
				'post_title'  => 'Post Excerpt',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'post_excerpt',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'   => $post_type_arr,
				'ctype'     => 'textarea',
				'htmlvar_name'  => 'post_excerpt',
				'sort_order'   => '4',
				'is_active'   => '1',
				'is_require'   => '0',
				'show_on_page'  => 'user_side',
				'show_in_column' => '0',
				'show_on_listing' => '1',
				'is_edit'    => 'true',
				'show_on_detail' => '1',
				'show_in_column' => '0',
				'is_search'   => '0',
				'is_submit_field' => '0',
				'heading_type'  => '[#taxonomy_name#]',
				);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}

			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . $_ex_post_type . '' , 'all' );
			}
		} else {
			/* Set always active post if user deactive */
			update_post_meta( $post_content->ID, 'is_active', '1' );

			$post_type = get_post_meta( $post_content->ID, 'post_type', true );

			update_post_meta( $post_content->ID, 'post_type_post', 'post' );
			update_post_meta( $post_content->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( $post_content->ID, 'show_in_post_search', '1' );

			if ( get_post_meta( $post_content->ID, 'post_sort_order', true ) ) {
				update_post_meta( $post_content->ID, 'post_sort_order', get_post_meta( $post_content->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $post_content->ID, 'post_sort_order', 3 );
			}

			if ( get_post_meta( $post_content->ID, 'post_heading_type', true ) ) {
				update_post_meta( $post_content->ID, 'post_heading_type', get_post_meta( $post_content->ID, 'post_heading_type', true ) );
			} else {
				update_post_meta( $post_content->ID, 'post_heading_type', '[#taxonomy_name#]' );
			}

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_content->ID, $el_type = 'post_custom_fields', $post_content->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_content->ID, 'custom_fields' );
				}
			}
		}// End if().
		/* Finish The post excerpt custom field */
		/* Insert Post Contact Info heading into posts */
		$field_label = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'field_label' and $wpdb->posts.post_type = 'custom_fields'" );

		if ( !empty( $field_label ) ) {
			$my_post = array(
				'post_title' => 'Label of Field',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name' => 'field_label',
				'post_type' => 'custom_fields',
				);
			$post_meta = array(
				'post_type' => $post_type_arr,
				'post_type_post' => 'post',
				'ctype' => 'heading_type',
				'htmlvar_name' => 'field_label',
				'field_category' => 'all',
				'sort_order' => '19',
				'event_sort_order' => '19',
				'is_active' => '1',
				'is_submit_field' => '0',
				'is_require' => '0',
				'show_on_page' => 'both_side',
				'show_in_column' => '0',
				'show_on_post' => '0',
				'is_edit' => 'true',
				'show_on_detail' => '1',
				'is_search' => '0',
				'show_in_email' => '1',
				'is_delete' => '0',
				);
			wp_set_post_terms( @$post_id, '1', 'category', true );
			$post_id = wp_insert_post( $my_post );

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}

			/*wp_set_post_terms( $post_id, '1', 'category', true );*/
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}
		} else {
			$post_type = get_post_meta( @$field_label->ID, 'post_type', true );

			update_post_meta( @$field_label->ID, 'post_type_post', 'post' );
			update_post_meta( @$field_label->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( @$field_label->ID, 'show_in_post_search', '1' );

			if ( get_post_meta( @$field_label->ID, 'post_sort_order', true ) ) {
				update_post_meta( @$field_label->ID, 'post_sort_order', get_post_meta( @$field_label->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( @$field_label->ID, 'post_sort_order', 4 );
			}

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $field_label->ID, $el_type = 'post_custom_fields', $field_label->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $field_label->ID, 'custom_fields' );
				}
			}
		}// End if().
		/* Insert Post image_uploader into posts */
		$post_images = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'post_images' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( $post_images->ID =='') {
			$my_post = array(
				'post_title'  => 'Post Images',
				'post_content' => '',
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name'  => 'post_images',
				'post_type'  => 'custom_fields',
				);
			$post_meta = array(
				'post_type'	  => $post_type_arr,
				'post_type_post' => 'post',
				'ctype'		  => 'image_uploader',
				'site_title'	  => 'Post Images',
				'htmlvar_name'  => 'post_images',
				'sort_order' 	  => '5',
				'listing_sort_order' 	  => '5',
				'is_active' 	  => '1',
				'is_require' 	  => '1',
				'show_on_page'  => 'user_side',
				'show_in_column' => '0',
				'show_on_detail' => '1',
				'show_on_listing' => '1',
				'show_in_email'  => '0',
				'is_edit'     => 'true',
				'validation_type' => 'require',
				'is_search'    => '0',
				'is_submit_field' => '1',
				'listing_heading_type'  => '[#taxonomy_name#]',
				'heading_type'  => '[#taxonomy_name#]',
				);
			$post_id = wp_insert_post( $my_post );
			/* Finish the place geo_latitude and geo_longitude in postcodes table*/
			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_id, $el_type = 'post_custom_fields', $post_id, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_id, 'custom_fields' );
				}
			}
			wp_set_post_terms( $post_id, '1', 'category', true );
			foreach ( $post_meta as $key => $_post_meta ) {
				add_post_meta( $post_id, $key, $_post_meta );
			}

			$ex_post_type = '';
			$ex_post_type = explode( ',', $post_type_arr );
			foreach ( $ex_post_type as $_ex_post_type ) {
				add_post_meta( $post_id, 'post_type_' . trim( $_ex_post_type ) . '' , 'all' );
			}
		} else {
			/* Set always active post if user deactive */
			update_post_meta( $post_images->ID, 'is_active', '1' );

			$post_type = get_post_meta( $post_images->ID, 'post_type', true );

			update_post_meta( $post_images->ID, 'post_type_post', 'post' );
			update_post_meta( $post_images->ID, 'taxonomy_type_category', 'category' );
			update_post_meta( $post_images->ID, 'show_in_post_search', '1' );

			if ( get_post_meta( $post_images->ID, 'post_sort_order', true ) ) {
				update_post_meta( $post_images->ID, 'post_sort_order', get_post_meta( $post_images->ID, 'post_sort_order', true ) );
			} else {
				update_post_meta( $post_images->ID, 'post_sort_order', 4 );
			}

			if ( get_post_meta( $post_images->ID, 'post_heading_type', true ) ) {
				update_post_meta( $post_images->ID, 'post_heading_type', get_post_meta( $post_content->ID, 'post_heading_type', true ) );
			} else {
				update_post_meta( $post_images->ID, 'post_heading_type', 'Label of Field' );
			}

			if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
				global $sitepress;
				$current_lang_code = ICL_LANGUAGE_CODE;
				$default_language = $sitepress->get_default_language();
				/* Insert wpml icl_translations table*/
				$sitepress->set_element_language_details( $post_images->ID, $el_type = 'post_custom_fields', $post_images->ID, $current_lang_code, $default_language );
				if ( function_exists( 'wpml_insert_templ_post' ) ) {
					wpml_insert_templ_post( $post_images->ID, 'custom_fields' );
				}
			}
		}// End if().

		/* Finish the post images custom fields */
		$post_tags = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'post_tags' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( @$post_tags->ID =='' ) {
		} else {
			update_post_meta( $post_tags->ID, 'is_edit', 'true' );
		}
		/* Finish the taxonomy name heading custom fields */

		/* Reset Location & Map type if user changes */
		$post_location_info = $wpdb->get_row( "SELECT post_title,ID FROM $wpdb->posts WHERE $wpdb->posts.post_name = 'locations_info' and $wpdb->posts.post_type = 'custom_fields'" );
		if ( !empty( $post_location_info ) ) {
			update_post_meta( $post_location_info->ID, 'ctype', 'heading_type' );
		}
		if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_custom_filed' ) == '' ) {
			update_option( 'tmpl_wpml_custom_filed', 'inserted' );
		}
		global $wp_post_types;
		if ( isset( $wp_post_types['custom_fields'] ) ) {
			unset( $wp_post_types['custom_fields'] );
		}
	}// End if().

}

/**
 * Create action for general settings in tevolution
 */
function post_page_setting_data( $column ) {
	$tmpdata = get_option( 'templatic_settings' );

	$templatic_theme = wp_get_theme();
	?>
	<p class="tevolution_desc"> <?php echo wp_kses_post( wp_unslash( __( 'This is the main Tevolution settings area. As you add Tevolution add-ons their settings will appear here. <br><b>Note:</b> Do not forget to click on "Save all settings" at the bottom when done with tweaking settings. You should also clear Tevolution cache (top of the page) after every major change. ', 'templatic-admin' ) ) );?> </p>

	<div id="theme_support_setting">
		<?php
		if ( strtolower( $templatic_theme->get( 'Author' ) ) != 'templatic' && ( ! current_theme_supports( 'home_listing_type_value' ) || ((function_exists( 'directory_admin_notices' ) || function_exists( 'event_manager_admin_notices' ) ) && ( ! current_theme_supports( 'tev_taxonomy_sorting_opt' ) || ! current_theme_supports( 'tev_taxonomy_excerpt_opt' ) ) ) ) ) :?>
		<p><?php echo esc_html__( "If you are not using one of Directory based themes from templatic then copy below code and paste it in your theme's functions.php file located in your active WordPress directory to enhance your theme functionality.", 'templatic-admin' ); ?></p>
	<?php endif;

		if ( strtolower( $templatic_theme->get( 'Author' ) ) != 'templatic' && ! current_theme_supports( 'home_listing_type_value' ) ) :?>
			<p class="tevolution_desc"><?php echo esc_html__( 'Display different post type on home page  -  add_theme_support("home_listing_type_value");', 'templatic-admin' ); ?></p>
		<?php endif;

		if ( strtolower( $templatic_theme->get( 'Author' ) ) != 'templatic' && ! current_theme_supports( 'author_box' ) ) :?>
				<p class="tevolution_desc"><?php echo esc_html__( 'Display different post type on author page  -  do_action("author_box") on author page;', 'templatic-admin' ); ?></p>
				<?php endif;

		if ( strtolower( $templatic_theme->get( 'Author' ) ) != 'templatic' && ! current_theme_supports( 'tev_taxonomy_sorting_opt' ) && function_exists( 'directory_admin_notices' ) ) :?>
				<p class="tevolution_desc"><?php echo esc_html__( 'Display sorting option on taxonomy page  -  add_theme_support("tev_taxonomy_sorting_opt");', 'templatic-admin' ); ?></p>
				<?php endif;

		if ( strtolower( $templatic_theme->get( 'Author' ) ) != 'templatic' && ! current_theme_supports( 'tev_taxonomy_excerpt_opt' ) && function_exists( 'directory_admin_notices' ) ) :?>
				<p class="tevolution_desc"><?php echo esc_html__( 'Display excerpt setting on post listing page  -  add_theme_support("tev_taxonomy_excerpt_opt");', 'templatic-admin' ); ?></p>
				<?php endif;?>
</div>

<!-- Sub Menu For General Settings Section-->
<div class="wp-filter tev-sub-menu" >
	<ul id="tev_general_settings" class="filter-links">
		<li class="submit_page_settings active"><a id="submit_page_settings" href="javascript:void(0);" class="current"><?php echo esc_html__( 'Submission Page', 'templatic-admin' ); ?></a></li>
		<?php do_action( 'tevolution_before_subsettings' );

		/* show if current theme support - home page display with different post types OR not */
		if ( current_theme_supports( 'theme_home_page' ) && get_option( 'show_on_front' ) == 'posts' ) {
			?>
			<li class="home_page_settings"><a id="home_page_settings" href="javascript:void(0);"><?php echo esc_html__( 'Home page', 'templatic-admin' ); ?></a></li>
			<?php
		}
		do_action( 'tevolution_after_homepagelink' );
		if ( current_theme_supports( 'home_listing_type_value' ) || current_theme_supports( 'tev_taxonomy_excerpt_opt' ) ) : ?>
		<li class="listing_page_settings"><a id="listing_page_settings" href="javascript:void(0);"><?php echo esc_html__( 'Category Page', 'templatic-admin' ); ?></a></li>
	<?php endif;
		do_action( 'tevolution_after_catpagelink' );
	?>

	<li class="detail_page_settings"><a id="detail_page_settings" href="javascript:void(0);"><?php echo esc_html__( 'Detail Page', 'templatic-admin' ); ?></a></li>
	<?php do_action( 'tevolution_after_detailpagelink' ); ?>

	<li class="registration_page_setup"><a id="registration_page_setup" href="javascript:void(0);" ><?php echo esc_html__( 'Registration Page', 'templatic-admin' ); ?></a></li>
	<?php
	do_action( 'tevolution_after_regpagelink' );
	?>
	<?php
	/* add theme support for not show in theme */
	/* This condition for Publisher/digiseller */
	if ( ! current_theme_supports( 'theme_not_support_claim_ownership' ) ) : ?>
	<li class="general_claim_setting"><a id="general_claim_setting" href="javascript:void(0);"><?php echo esc_html__( 'Claim Ownership', 'templatic-admin' ); ?></a></li>
<?php endif; ?>

<?php do_action( 'tevolution_after_subsettings' ); ?>

<li class="captcha_settings"><a id="captcha_settings" href="javascript:void(0);"><?php echo esc_html__( 'Captcha', 'templatic-admin' ); ?></a></li>
</ul>
</div>
<?php
do_action( 'tmpl_start_general_settings' );
/* Category page settings start */
?>
<!-- Submit page settings start -->
<table id="submit_page_settings" class="tmpl-general-settings form-table active-tab">
	<tr>
		<td colspan="2">
			<p class="tevolution_desc"><strong><?php _e( 'Tip: ', 'templatic-admin' ); ?></strong><?php echo sprintf( wp_kses_post( wp_unslash( __( 'Generate a submission page for a new post type by entering the following shortcode in a new page <strong>[submit_form post_type= &acute;your_post_type_name&acute;]</strong>. For details on this please open the %s', 'templatic-admin' ) ) ), '<a href="//templatic.com/docs/tevolution-guide" target= "_blank" > documentation guide</a>' ); ?></p><br />
		</td>
	</tr>
	<tr id="category_specific_fields" >
		<th>
			<label><?php echo esc_html__( 'Category specific fields', 'templatic-admin' );
			$templatic_category_custom_fields = @$tmpdata['templatic-category_custom_fields'];
			if ( ! isset( $templatic_category_custom_fields ) && $templatic_category_custom_fields == '' ) {update_option( 'templatic-category_custom_fields', 'No' );}?></label>
		</th>
		<td>

			<div class="input-switch">
				<input type="checkbox" id="templatic-category_custom_fields" name="templatic-category_custom_fields" value="Yes" <?php if ( $templatic_category_custom_fields == 'Yes' || $templatic_category_custom_fields == '' ) {?>checked="checked"<?php }?> />
				<label for="templatic-category_custom_fields" class="checkbox">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label>
			</div>

			<p class="description"><?php echo wp_kses_post( wp_unslash( __( 'Displays different fields for different categories on submission page. For more information, open the <a href="//templatic.com/docs/tevolution-guide/#basic_settings" title="Tevolution Guid" target="_blank">Custom Fields Guide</a>', 'templatic-admin' ) ) );?></p>
		</td>
	</tr>
	<tr id="category_specific_search_fields" >
		<th>
			<label><?php echo esc_html__( 'Category specific advanced search', 'templatic-admin' );
			$category_specific_search_fields = @$tmpdata['templatic-category_custom_search_fields'];
			if ( ! isset( $category_specific_search_fields ) && $category_specific_search_fields == '' ) {update_option( 'templatic-category_custom_search_fields', 'No' );}?></label>
		</th>
		<td>


			<div class="input-switch">
				<input type="checkbox" id="templatic-category_custom_search_fields" name="templatic-category_custom_search_fields" value="Yes" <?php if ( $category_specific_search_fields == 'Yes' ) {?>checked="checked"<?php }?> />
				<label for="templatic-category_custom_search_fields" class="checkbox">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label>
			</div>

			<p class="description"><?php echo esc_html__( 'Displays different fields for different categories on the Advanced Search widget', 'templatic-admin' );?></p>
		</td>
	</tr>
	<tr id="submission_page_hide_parnt_catgory">
		<th>
			<label><?php echo esc_html__( 'Disallow submission to parent categories.', 'templatic-admin' );
			$submission_pg_hide_parent_category = @$tmpdata['templatic-submission_pg_hide_parent_category'];
			if ( ! isset( $submission_pg_hide_parent_category ) && $submission_pg_hide_parent_category == '' ) {update_option( 'templatic-submission_pg_hide_parent_category', 'No' );}?></label>
		</th>
		<td>


			<div class="input-switch">
				<input type="checkbox" id="templatic-submission_pg_hide_parent_category" name="templatic-submission_pg_hide_parent_category" value="Yes" <?php if ( $submission_pg_hide_parent_category == 'Yes' ) {?>checked="checked"<?php }?> />
				<label for="templatic-submission_pg_hide_parent_category" class="checkbox">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label>
			</div>

			<p class="description"><?php echo esc_html__( 'Only allow submission to a sub-category.', 'templatic-admin' );?></p>
		</td>
	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Category Display', 'templatic-admin' ); ?></label></th>
		<td>
			<div class="element">
				<div class="input_wrap">
					<?php $templatic_category_type = @$tmpdata['templatic-category_type']; ?>
					<select id="templatic-category_type" name="templatic-category_type" style="vertical-align:top;width:200px;" >
						<option value="checkbox" <?php if ( $templatic_category_type == 'checkbox' ) { echo 'selected=selected'; } ?>><?php echo esc_html__( 'Check Box', 'templatic-admin' ); ?></option>
						<option value="multiselectbox" <?php if ( $templatic_category_type == 'multiselectbox' ) { echo 'selected=selected'; } ?>><?php echo esc_html__( 'Multi-select Box', 'templatic-admin' ); ?></option>
						<option value="select" <?php if ( $templatic_category_type == 'select' ) { echo 'selected=selected'; } ?>><?php echo esc_html__( 'Select Box', 'templatic-admin' ); ?></option>
						<option value="multi_level_cat" <?php if ( $templatic_category_type == 'multi_level_cat' ) { echo 'selected=selected'; } ?>><?php echo esc_html__( 'Multi Level Category Selection', 'templatic-admin' ); ?></option>
					</select>
				</div>
			</div>
			<label for="ilc_tag_class"><p class="description"><?php echo esc_html__( 'Specify the format in which you want to display the categories on ', 'templatic-admin' );?><a href="https://templatic.com/docs/tevolution-guide/#categorydisplay"><?php echo esc_html__( 'Submit page. ', 'templatic-admin' ); ?></a></p></label>
			<label for="ilc_tag_class"><p class="description"><?php echo esc_html__( 'NOTE : If Multi Level Category Selection is enabled the above Parent category hide on submission page will not work.', 'templatic-admin' );?></p></label>
		</td>
	</tr>

	<tr>
		<th><label><?php echo esc_html__( 'Maximum image upload size', 'templatic-admin' );
		$templatic_image_size = @$tmpdata['templatic_image_size']; ?></label></th>
		<td>
			<div class="element">
				<div class="input_wrap">
					<input type="text" id="templatic_image_size" name="templatic_image_size" value="<?php echo wp_kses_post( wp_unslash( $templatic_image_size ) ); ?>"/> </div>
				</div>
			</div>
			<label for="ilc_tag_class"><p class="description"><?php echo esc_html__( 'The size is in kilobytes, e.g. 1MB = 1024KB. Enter only the number. ', 'templatic-admin' );?></p></label>
		</td>
	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Default status for free submissions', 'templatic-admin' );
		$post_default_status = @$tmpdata['post_default_status']; ?></label></th>
		<td>
			<select name="post_default_status">
				<option value="draft" <?php if ( $post_default_status == 'draft' ) { echo 'selected';}?>><?php echo esc_html__( 'Draft', 'templatic-admin' ); ?></option>
				<option value="publish" <?php if ( $post_default_status == 'publish' ) { echo 'selected';}?>><?php echo esc_html__( 'Published', 'templatic-admin' ); ?></option>
			</select>
		</td>
	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Default status for paid submissions', 'templatic-admin' );
		$post_default_status_paid = @$tmpdata['post_default_status_paid']; ?></label></th>
		<td>
			<select name="post_default_status_paid">
				<option value="draft" <?php if ( $post_default_status_paid == 'draft' ) { echo 'selected';}?>><?php echo esc_html__( 'Draft', 'templatic-admin' ); ?></option>
				<option value="publish" <?php if ( $post_default_status_paid == 'publish' ) { echo 'selected';}?>><?php echo esc_html__( 'Published', 'templatic-admin' ); ?></option>
			</select>
		</td>
	</tr>

	<tr>
		<th><label><?php echo esc_html__( 'Default status for expired listings', 'templatic-admin' );
		$post_listing_ex_status = @$tmpdata['post_listing_ex_status']; ?></label></th>
		<td>
			<select name="post_listing_ex_status">
				<option value="draft" <?php if ( $post_listing_ex_status == 'draft' ) { echo 'selected';}?>><?php echo esc_html__( 'Draft', 'templatic-admin' ); ?></option>
				<option value="trash" <?php if ( $post_listing_ex_status == 'trash' ) { echo 'selected';}?>><?php echo esc_html__( 'Trash', 'templatic-admin' ); ?></option>
			</select>
		</td>
	</tr>

	<tr>
		<th><label><?php echo esc_html__( 'User listing expiry notification email', 'templatic-admin' );
		$listing_email_notification = @$tmpdata['listing_email_notification']; ?></label></th>
		<td>
			<select name="listing_email_notification">
				<option value="">-- Choose One --</option>
				<option value="1" <?php if ( $listing_email_notification == '1' ) { echo 'selected';}?>>1</option>
				<option value="2" <?php if ( $listing_email_notification == '2' ) { echo 'selected';}?>>2</option>
				<option value="3" <?php if ( $listing_email_notification == '3' ) { echo 'selected';}?>>3</option>
				<option value="4" <?php if ( $listing_email_notification == '4' ) { echo 'selected';}?>>4</option>
				<option value="5" <?php if ( $listing_email_notification == '5' ) { echo 'selected';}?>>5</option>
				<option value="6" <?php if ( $listing_email_notification == '6' ) { echo 'selected';}?>>6</option>
				<option value="7" <?php if ( $listing_email_notification == '7' ) { echo 'selected';}?>>7</option>
				<option value="8" <?php if ( $listing_email_notification == '8' ) { echo 'selected';}?>>8</option>
				<option value="9" <?php if ( $listing_email_notification == '9' ) { echo 'selected';}?>>9</option>
				<option value="10" <?php if ( $listing_email_notification == '10' ) { echo 'selected';}?>>10</option>
			</select>

			<p class="description"><?php echo esc_html__( 'Select number of days prior to expiry', 'templatic-admin' );?></p>
		</td>
	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Terms and conditions', 'templatic-admin' );
			$tev_accept_term_condition = @$tmpdata['tev_accept_term_condition'];
		if ( $tev_accept_term_condition == 1 ) { $checked = 'checked=checked'; } else {
			$checked = '';
		}
			?> <label> </th>
			<td>
				<div class="input-switch">
					<input id="tev_accept_term_condition" type="checkbox" value="1" name="tev_accept_term_condition" <?php echo wp_kses_post( wp_unslash( $checked ) ); ?>/>
					<label for="tev_accept_term_condition">&nbsp; <?php echo esc_html__( 'Enable', 'templatic-admin' ); ?></label>
				</div>
			</td>
		</tr>
		<?php do_action( 'templ_general_setting_before_tc' ); ?>
		<tr>
			<th><label><?php echo esc_html__( 'Terms and condition text', 'templatic-admin' );
				$term_condition_content = stripslashes( @$tmpdata['term_condition_content'] );
				?> <label> </th>
				<td>
					<textarea class="tb_textarea" id="term_condition_content" name="term_condition_content"><?php echo wp_kses_post( wp_unslash( $term_condition_content ) ); ?></textarea>
					<p class="description"><?php echo esc_html__( 'Enter your terms in the above box. You can use HTML to create a link to your full terms of use page. ', 'templatic-admin' );?></p>
				</td>
			</tr>

			<?php do_action( 'templ_submitform_new_row' ); ?>
			<tr>
				<td colspan="2">
					<p class="submit" style="clear: both;">
						<input type="submit" name="Submit" class="button button-primary button-hero" value="<?php echo esc_html__( 'Save All Settings', 'templatic-admin' );?>" />
						<input type="hidden" name="settings-submit" value="Y" />
					</p>
				</td>
			</tr>
		</table>

		<table id="listing_page_settings" class="tmpl-general-settings form-table">
			<?php
			$fl = 0;
			if ( current_theme_supports( 'home_listing_type_value' ) ) : $fl = 1; ?>
			<tr>
				<td colspan="2"><p class="tevolution_desc"><?php echo esc_html__( "Category page settings apply to the default 'listing' post type and any new custom post types you create.", 'templatic-admin' ); ?></p>
				</td>
			</tr>

		<?php endif;
			do_action( 'before_listing_page_setting' );
			do_action( 'tmpl_main_listing_page_setting' );
			do_action( 'after_listing_page_setting' );

			if ( current_theme_supports( 'tev_taxonomy_excerpt_opt' ) ) :?>
				<?php if ( $fl == 0 ) : ?>
			<tr>
				<th colspan="2"><div class="tevo_sub_title"><?php echo esc_html__( 'Category Page', 'templatic-admin' );?></div></th>
			</tr>
		<?php endif; ?>
				<tr>
					<th><label><?php echo esc_html__( 'Length Of Summary ', 'templatic-admin' ); ?></label></th>
					<td>
						<input type="text" name="excerpt_length" value="<?php echo wp_kses_post( wp_unslash( $tmpdata['excerpt_length'] ) ); ?>" />
						<p class="description"><?php echo esc_html__( "If you haven't entered excerpt in your post we will display here mentioned number of characters from your post description .", 'templatic-admin' );?></p>
					</td>
				</tr>
				<tr>
					<th><label><?php echo esc_html__( 'Title For Continue Link ', 'templatic-admin' ); ?></label></th>
					<td>
						<input type="text" name="excerpt_continue" value="<?php echo wp_kses_post( wp_unslash( $tmpdata['excerpt_continue'] ) ); ?>" />
						<p class="description"><?php echo esc_html__( 'Mention the title you want to show for a link which will be redirected to post detail page ', 'templatic-admin' );?></p>
					</td>
				</tr>
			<?php endif;

			if ( current_theme_supports( 'tev_taxonomy_sorting_opt' ) ) : ?>
					<tr class="templatic_sorting">
						<th valign="top"><label><?php echo esc_html__( 'Sorting options', 'templatic-admin' );?></label></th>
						<td>
							<label><input type="checkbox" class="checkall" name="sorting_option[]" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'select_all', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?> onclick="SelectAllSorting()" value="select_all" /> <?php echo esc_html__( 'Select all', 'templatic-admin' );?></label><br/>
							<label for="title_alphabetical"><input type="checkbox" id="title_alphabetical" name="sorting_option[]" value="title_alphabetical" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'title_alphabetical', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Alphabetical', 'templatic-admin' );?></label><br/>
							<label for="date_asc"><input type="checkbox" id="date_asc" name="sorting_option[]" value="date_asc" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'date_asc', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Publish Date Ascending', 'templatic-admin' );?></label><br/>
							<label for="date_desc"><input type="checkbox" id="date_desc" name="sorting_option[]" value="date_desc" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'date_desc', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Publish Date Descending', 'templatic-admin' );?></label><br />

							<label for="random"><input type="checkbox" id="random" name="sorting_option[]" value="random" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'random', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Random', 'templatic-admin' );?></label><br />

							<?php if ( $tmpdata['templatin_rating'] == 'yes' || is_plugin_active( 'Templatic-MultiRating/multiple_rating.php' ) ) { ?>
			<label for="rating"><input type="checkbox" id="rating" name="sorting_option[]" value="rating" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'rating', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Rating', 'templatic-admin' );?></label><br />
			<?php } ?>
							<label for="reviews"><input type="checkbox" id="reviews" name="sorting_option[]" value="reviews" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'reviews', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Reviews ', 'templatic-admin' );?></label><br />
							<label for="title_asc"><input type="checkbox" id="title_asc" name="sorting_option[]" value="title_asc" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'title_asc', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Title Ascending', 'templatic-admin' );?></label><br/>
							<label for="title_desc"><input type="checkbox" id="title_desc" name="sorting_option[]" value="title_desc" <?php if ( ! empty( $tmpdata['sorting_option'] ) && in_array( 'title_desc', $tmpdata['sorting_option'] ) ) {  echo 'checked';}?>/>&nbsp;<?php echo esc_html__( 'Title Descending', 'templatic-admin' );?></label><br />


							<?php do_action( 'taxonomy_sorting_option', 'sorting_option' );?>
							<p class="description"><?php echo esc_html__( 'For the "Rating" option to work you must enable the "Show rating" setting available in the "Detail Page" tab above. ', 'templatic-admin' );?></p>
							<script type="text/javascript">
								function SelectAllSorting()
								{
									jQuery( '.templatic_sorting' ).find( ':checkbox' ).attr( 'checked', jQuery( '.checkall' ).is(":checked" ) ) ;
								}
							</script>
						</td>
					</tr>
					<?php do_action( 'after_listing_page_sorting' );/* do action after listing page sorting option*/
	endif;
	do_action( 'tmpl_enable_lazy_load' );
		?>
		<tr id="tmpl_enable_lazy_load" <?php echo $css; ?>>
			<th valign="top"><label><?php echo __( 'Lazy Load','templatic-admin' );?></label></th>
			<td>
				<div class="input-switch">
					<input id="tmpl_enable_lazy_load1" type="checkbox" value="1" <?php if ( @$tmpdata['tmpl_enable_lazy_load'] == '1' ) { echo 'checked=checked';}?> name="tmpl_enable_lazy_load">
					<label for="tmpl_enable_lazy_load1"><?php _e( 'Enable','templatic-admin' ); ?></label>    
				</div>
				<p class="description"><?php echo __( 'Lazy load for images will be enable on listing page','templatic-admin' );?></p>
			</td>
		</tr>
	<?php
	do_action( 'tmpl_after_enable_lazy_load' );?>
	<tr>
		<td colspan="2">
			<p class="submit" style="clear: both;">
				<input type="submit" name="Submit" class="button button-primary button-hero" value="<?php echo esc_html__( 'Save All Settings', 'templatic-admin' );?>" />
				<input type="hidden" name="settings-submit" value="Y" />
			</p>
		</td>
	</tr>
</table>

<table id="detail_page_settings" class="tmpl-general-settings form-table">
	<tr>
		<td colspan="2"><p class="tevolution_desc"><?php echo esc_html__( 'Control your detail page settings from this screen which will affect the user experience for your visitors. ', 'templatic-admin' );?></p></div>
		</td>
	</tr>
	<?php do_action( 'before_detail_page_setting' );

	do_action( 'before_related_post' );?>
	<tr id="related_posts">
		<th><label><?php echo esc_html__( 'Filter related posts by', 'templatic-admin' );
		$related_post = @$tmpdata['related_post']; ?></label></th>
		<td>
			<label for="related_post_categories"><input id="related_post_categories" type="radio" name="related_post" value="categories" <?php if ( isset( $related_post ) && $related_post == 'categories' ) { echo 'checked';} ?>/>&nbsp;<?php echo esc_html__( 'Category', 'templatic-admin' );?></label>&nbsp;&nbsp;
			<label for="related_post_tags"> <input id="related_post_tags" type="radio" name="related_post" value="tags" <?php if ( isset( $related_post ) && $related_post == 'tags' ) { echo 'checked';} ?>/>&nbsp;<?php echo esc_html__( 'Tag', 'templatic-admin' );?></label>
		</td>
	</tr>
	<tr id="no_related_post">
		<th><label><?php echo esc_html__( 'Number of related posts', 'templatic-admin' );
		$related_post_numbers = @$tmpdata['related_post_numbers']; ?></label></th>
		<td>
			<label for="related_post_numbers">
				<input id="related_post_numbers" type="text" value="<?php if ( isset( $related_post_numbers ) ) { echo wp_kses_post( wp_unslash( $related_post_numbers ) );
} else { echo 3;} ?>" size="4" name="related_post_numbers">
			</label>
		</td>
	</tr>

	<?php do_action( 'after_related_post' );

	if ( ! current_theme_supports( 'remove_tevolution_sharing_opts' ) ) { ?>
	<tr>
		<th><label><?php echo esc_html__( 'View counters', 'templatic-admin' );
		$templatic_view_counter = @$tmpdata['templatic_view_counter']; ?></label></th>
		<td>
			<div class="input-switch">
				<input type="checkbox" name="templatic_view_counter" value="Yes" <?php if ( $templatic_view_counter == 'Yes' || $templatic_view_counter == '' ) {?>checked="checked"<?php }?> id="yes" /><label for="yes">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?>	</label>
			</div>
		</td>
	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Show sharing buttons', 'templatic-admin' );?></label></th>
		<td>
			<?php
			$facebook_share_detail_page = @$tmpdata['facebook_share_detail_page'];
			$twitter_share_detail_page = @$tmpdata['twitter_share_detail_page'];
			$pintrest_detail_page = @$tmpdata['pintrest_detail_page'];
			?>
			<label for="facebook_share_detail_page_yes"><input id="facebook_share_detail_page_yes" type="checkbox" name="facebook_share_detail_page" value="yes" <?php if ( isset( $facebook_share_detail_page ) && $facebook_share_detail_page == 'yes' ) { echo 'checked';} ?>/>&nbsp;<?php echo esc_html__( 'Facebook', 'templatic-admin' );?></label> <br/>

			<label for="pintrest_detail_page_yes"><input id="pintrest_detail_page_yes" type="checkbox" name="pintrest_detail_page" value="yes" <?php if ( isset( $pintrest_detail_page ) && $pintrest_detail_page == 'yes' ) { echo 'checked';} ?>/>&nbsp;<?php echo esc_html__( 'Pintrest', 'templatic-admin' );?></label> <br/>

			<label for="twitter_share_detail_page_yes"><input id="twitter_share_detail_page_yes" type="checkbox" name="twitter_share_detail_page" value="yes" <?php if ( isset( $twitter_share_detail_page ) && $twitter_share_detail_page == 'yes' ) { echo 'checked';} ?>/>&nbsp;<?php echo esc_html__( 'Twitter', 'templatic-admin' );?></label> <br/>

			<p class="description"><?php echo esc_html__( 'Once enabled, selected sharing buttons will appear below the image gallery on detail pages', 'templatic-admin' );?></p>
			<?php do_action( 'test' ); ?>
		</td>

	</tr>
	<tr>
		<th><label><?php echo esc_html__( 'Facebook Access Token ', 'templatic-admin' );
		$fb_access_token = @$tmpdata['fb_access_token'];?></label></th>
		<td>
			<label for="fb_access_token">
				<input id="fb_access_token" type="text" value="<?php if ( isset( $fb_access_token ) ) { echo wp_kses_post( wp_unslash( $fb_access_token ) );} ?>" name="fb_access_token" placeholder="App ID|App Secret">
			</label>
			<p class="description"><?php echo esc_html__( 'Enter facebook access token for share count. Enter App Id and App Secret together as access token. ', 'templatic-admin' );?></p>
		</td>
	</tr>
	<?php
	}// End if().
	do_action( 'after_detail_page_setting' );

?>
<tr>
	<td colspan="2">
		<p class="submit" style="clear: both;">
			<input type="submit" name="Submit" class="button button-primary button-hero" value="<?php echo esc_html__( 'Save All Settings', 'templatic-admin' );?>" />
			<input type="hidden" name="settings-submit" value="Y" />
		</p>
	</td>
</tr>
</table>


<?php
}


/*
	post_expire_session_table_create table, when any post expired then it willmanage with the entry of this table
 */
function post_expire_session_table_create() {
	/* Check if auto install completed then perform below step incase user deteleted default settings */
	if ( get_option( 'tmpl_is_tev_auto_insall' ) == 'true' || ( is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) ) :
		global $wpdb, $pagenow;
		$table_name = $wpdb->prefix . 'post_expire_session';
		if ( get_option( 'tmpl_is_tev_auto_insall' ) == 'false' && is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) { $pagenow = 'plugins.php'; }
		if ( ( $pagenow == 'plugins.php' || (isset( $_REQUEST['page'] ) && ( $_REQUEST['page'] == 'templatic_system_menu' || $_REQUEST['page'] == 'transcation' || $_REQUEST['page'] == 'monetization' ) ) ) && get_option( 'tev_table_updates' ) != 'inserted' ) {

			if ( $wpdb->get_var( "SHOW TABLES LIKE '$table_name'" ) != $table_name ) {
				$sql = 'CREATE TABLE `' . $table_name . '` (
					`session_id` BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
					`execute_date` DATE NOT NULL ,
					`is_run` TINYINT( 4 ) NOT NULL DEFAULT "0"
					)DEFAULT CHARSET=utf8';
				$wpdb->query( $sql );
			}
			$field_check = $wpdb->get_var( "SHOW COLUMNS FROM $wpdb->terms LIKE 'term_price'" );
			if ( 'term_price' != $field_check ) {
				$wpdb->query( "ALTER TABLE $wpdb->terms ADD term_price varchar(100) NOT NULL DEFAULT '0'" );
			}

			update_option( 'tev_table_updates', 'inserted' );
		}
endif;

}
/*
 * display message on admin notices for clear tevolution query cache
 */
function tevolution_custom_fields_notice() {
	global $wpdb;
	$taxonomy = get_option( 'templatic_custom_taxonomy' );
	$tag = get_option( 'templatic_custom_tags' );
	if ( (isset( $_REQUEST['ctab'] ) && ( $_REQUEST['ctab'] == 'custom_fields' || ( isset( $_REQUEST['page'] ) && wp_kses_post( wp_unslash( $_REQUEST['page'] ) ) == 'custom_taxonomies_permalink' ) ) && ! isset( $_REQUEST['activated'] ) )  || (isset( $_REQUEST['taxonomy'] ) && array_key_exists( $_REQUEST['taxonomy'], $taxonomy ) )  || (isset( $_REQUEST['taxonomy'] ) && array_key_exists( $_REQUEST['taxonomy'], $tag ) )  || (isset( $_REQUEST['page'] ) && ( wp_kses_post( wp_unslash( $_REQUEST['page'] ) ) == 'custom_setup' || wp_kses_post( wp_unslash( $_REQUEST['page'] ) ) == 'templatic_settings' ) ) ) {

		if ( isset( $_POST['tevolution_query'] ) && $_POST['tevolution_query'] != '' && isset( $_POST['tevolution_cache'] ) && $_POST['tevolution_cache'] == 1 ) {
			$wpdb->query( $wpdb->prepare( "DELETE FROM $wpdb->options WHERE option_name like '%s'", '%_tevolution_query_%' ) );
			update_option( 'tevolution_query_cache', 0 );
			?>
			<div id="tevolution_message" class="updated fade below-h2">
				<p><?php echo esc_html__( 'Tevolution cache has been successfully cleared. ', 'templatic-admin' );?></p>
			</div>
			<?php
		}

		if ( isset( $_POST['tevolution_query_cache'] ) && $_POST['tevolution_query_cache'] != '' && isset( $_REQUEST['tevolution_cache_disable'] ) ) {
			update_option( 'tevolution_cache_disable', wp_kses_post( wp_unslash( $_REQUEST['tevolution_cache_disable'] ) ) );
		}

		$tevolution_query_cache = get_option( 'tevolution_query_cache' );
		$tevolution_cache_disable = get_option( 'tevolution_cache_disable' );
		do_action( 'before_cache_msg' );
		if ( ! isset( $_POST['tevolution_query'] ) ) { ?>
		<div id="message" class="update-nag below-h2 tev-cache-msg clearfix" style="width: 60%; height: 40px;">

			<?php if ( $tevolution_cache_disable == 1 ) { ?>
			<div>
				<form action="" method="post" style="width: 70%; float: left;">
					<input type="hidden" name="tevolution_cache" value="1" />
					<p><?php echo esc_html__( 'In order to apply the changes made to the site you must clear the Tevolution cache. ', 'templatic-admin' );?> <input class="button-primary" type="submit" name="tevolution_query" value="<?php echo esc_html__( 'Clear cache', 'templatic-admin' );?>" /></p>
				</form>
				<form action="" method="post" style="float: left; margin: 12px 0px;">
					<input type="hidden" name="tevolution_cache_disable" value=""/><input class="button-secondary" type="submit" name="tevolution_query_cache" value="<?php echo esc_html__( 'Disable Cache', 'templatic-admin' );?>" />
				</form></div>

				<?php } else { ?>
				<form action="" method="post" style="width: 50%; float: left; text-align:right;"><p><?php echo esc_html__( 'Tevolution caching is disabled. ', 'templatic-admin' );?>&nbsp;&nbsp;</p></form>
				<form action="" method="post" style="width: 50%; float: left; margin: 10px 0px; text-align:left;">
					<input type="hidden" name="tevolution_cache_disable" value="1"/><input class="button-secondary" type="submit" name="tevolution_query_cache" value="<?php echo esc_html__( 'Enable Cache', 'templatic-admin' );?>" />
				</form>
				<?php } ?>
			</div>
			<?php
		}
		do_action( 'after_cache_msg' );
	}// End if().
}


add_action( 'init', 'tevolution_post_upgrade_success' );
/**
 * Change information for upgraded post
 */
function tevolution_post_upgrade_success() {
	if ( isset( $_REQUEST['pmethod'] ) && $_REQUEST['pmethod'] != '' && isset( $_REQUEST['pid'] ) && $_REQUEST['pid'] != '' && isset( $_REQUEST['upgrade'] ) && $_REQUEST['upgrade'] == 'pkg' ) {
		remove_action( 'paypal_successfull_return_content', 'successfull_return_paypal_content', 10 );
		remove_action( 'paypalpro_successfull_return_content', 'successfull_return_paypal_content', 10 );
		remove_action( 'paypalpro_submit_post_details', 'successfull_return_paypal_content', 10 );
		remove_action( 'strip_successfull_return_content', 'successfull_return_paypal_content', 10 );
		remove_action( 'strip_submit_post_details', 'successfull_return_paypal_content', 10 );
		remove_action( 'strip_successfull_return_content', 'successfull_return_paypal_content', 10 );
		remove_action( 'braintree_successfull_return_content', 'successfull_return_paypal_content', 10 );

		add_action( 'inspire_commerce_successfull_return_content', 'successfull_return_paypal_content_message', 10 );
		add_action( 'braintree_successfull_return_content', 'successfull_return_paypal_content_message', 10 );
		add_action( 'strip_submit_post_details', 'successfull_return_paypal_content_message', 10 );
		add_action( 'paypal_successfull_return_content', 'successfull_return_paypal_content_message', 10 );
		add_action( 'paypalpro_submit_post_details', 'successfull_return_paypal_content_message', 10 );
		remove_action( 'tevolution_submition_success_post_content', 'tevolution_submition_success_post_submited_content', 10 );
		include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/post_upgrade_pay_success.php' );
	}
}

/*
 * change succes message of post upgrade
 */
function successfull_return_paypal_content_message() {

	global $post, $wp_query;
	if ( isset( $_REQUEST['pid'] ) ) {
		$pid = intval( $_REQUEST['pid'] );
	}
	$pkg_details = get_post_meta( $pid, 'upgrade_data', true );
	$paid_amount = get_post_meta( $pid, 'paid_amount', true );
	$package_select = $pkg_details['package_select'];
	$pkgdata = get_post( $package_select );
	$ptype = get_post_meta( $pkgdata->ID, 'package_type', true );
	if ( $ptype == 2 ) {
		$allow = get_post_meta( $pkgdata->ID, 'limit_no_post', true );
		$taxonomies = get_post_meta( $pkgdata->ID, 'package_post_type', true );
		$pst_types = get_post_types();
		$taxonomies = explode( ',', $taxonomies );
		for ( $t = 0; $t <= count( $taxonomies ); $t++ ) {
			if ( in_array( $taxonomies[ $t ], $pst_types ) ) {
				$taxonomies1 .= Ucfirst( $taxonomies[ $t ] ) . ',';
			}
		}

		$subcontent = sprintf( __( 'This package allows you to submit %1$s posts in %2$s', 'templatic-admin' ), $allow,'<strong>' . rtrim( $taxonomies1, ', ' ) . '</strong>' );
	}
	$post_tax = fetch_page_taxonomy( $pkg_details['cur_post_id'] );
	/* Here array separated by category id and price amount */

	if ( $pkg_details['category'] ) {
		$category_arr = $pkg_details['category'];
		foreach ( $category_arr as $_category_arr ) {
			$category[] = explode( ',', $_category_arr );
		}
		foreach ( $category as $_category ) {
			$post_category[] = $_category[0];
		}
	}
	/* set post categories start */
	wp_set_post_terms( $pid, '', $post_tax,false );
	if ( $post_category ) {
		foreach ( $post_category as $_post_category ) {
			if ( taxonomy_exists( $post_tax ) ) :
				wp_set_post_terms( $pid, $_post_category, $post_tax,true );
			endif;
		}
	}
	/* set post categories end */
	$pkgname = $pkgdata->post_title;
	$subject = __( 'Payment procedure has been completed. ', 'templatic-admin' );

	$content = sprintf( __( 'You have now upgraded to a new package %1$s You paid %2$s to upgrade your package. ', 'templatic' ),'<strong>' . $pkgname . '</strong>.<br/>','<strong>' . display_amount_with_currency_plugin( $paid_amount ) . '</strong>' );
	echo '<h2>' . wp_kses_post( wp_unslash( $subject ) ) . '</h2>';
	echo '<p>' . wp_kses_post( wp_unslash( $content ) ) . '</p>';
	echo '<p>' . wp_kses_post( wp_unslash( $subcontent ) ) . '</p>';
}

add_action( 'templatic_general_setting_data', 'tmpl_captcha_setting_option', 30 );
/**
 * Hook which display the captcha settings on general settings area of tevolution.
 */
function tmpl_captcha_setting_option() {
	$tmpdata = get_option( 'templatic_settings' );
	$user_verification_page = @$tmpdata['user_verification_page'];
	do_action( 'tmpl_before_start_captcha_settings' );
	/*if captcha plugin is enabled than deactivate and update the option from it in templatic settings*/
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if ( is_plugin_active( 'wp-recaptcha/wp-recaptcha.php' ) ) {
		$captcha_option = get_option( 'recaptcha_options' );
		$site_key = $captcha_option['site_key'];
		$secretkey = $captcha_option['secret'];
		$comments_theme = $captcha_option['comments_theme'];
		$recaptcha_language = $captcha_option['recaptcha_language'];
		$tmpdata['site_key'] = $site_key;
		$tmpdata['secret'] = $secretkey;
		$tmpdata['comments_theme'] = $comments_theme;
		$tmpdata['captcha_language'] = $recaptcha_language;
		/*update captcha settings*/
		update_option( 'templatic_settings', $tmpdata );
		/*deactivate captcha plugin*/
		deactivate_plugins( ( 'wp-recaptcha/wp-recaptcha.php' ) );
	}

	$lang_array = array(
		'en' => __( 'English', 'templatic-admin' ),
		'ar' => __( 'Arabic', 'templatic-admin' ),
		'bg' => __( 'Bulgarian', 'templatic-admin' ),
		'ca' => __( 'Catalan Valencian', 'templatic-admin' ),
		'cs' => __( 'Czech', 'templatic-admin' ),
		'da' => __( 'Danish', 'templatic-admin' ),
		'de' => __( 'German', 'templatic-admin' ),
		'el' => __( 'Greek', 'templatic-admin' ),
		'en_gb' => __( 'British English', 'templatic-admin' ),
		'es' => __( 'Spanish', 'templatic-admin' ),
		'fa' => __( 'Persian', 'templatic-admin' ),
		'fr' => __( 'French', 'templatic-admin' ),
		'fr_ca' => __( 'Canadian French', 'templatic-admin' ),
		'hi' => __( 'Hindi', 'templatic-admin' ),
		'hr' => __( 'Croatian', 'templatic-admin' ),
		'hu' => __( 'Hungarian', 'templatic-admin' ),
		'id' => __( 'Indonesian', 'templatic-admin' ),
		'it' => __( 'Italian', 'templatic-admin' ),
		'iw' => __( 'Hebrew', 'templatic-admin' ),
		'ja' => __( 'Jananese', 'templatic-admin' ),
		'ko' => __( 'Korean', 'templatic-admin' ),
		'lt' => __( 'Lithuanian', 'templatic-admin' ),
		'lv' => __( 'Latvian', 'templatic-admin' ),
		'nl' => __( 'Dutch', 'templatic-admin' ),
		'no' => __( 'Norwegian', 'templatic-admin' ),
		'pl' => __( 'Polish', 'templatic-admin' ),
		'pt' => __( 'Portuguese', 'templatic-admin' ),
		'ro' => __( 'Romanian', 'templatic-admin' ),
		'ru' => __( 'Russian', 'templatic-admin' ),
		'sk' => __( 'Slovak', 'templatic-admin' ),
		'sl' => __( 'Slovene', 'templatic-admin' ),
		'sr' => __( 'Serbian', 'templatic-admin' ),
		'sv' => __( 'Swedish', 'templatic-admin' ),
		'th' => __( 'Thai', 'templatic-admin' ),
		'tr' => __( 'Turkish', 'templatic-admin' ),
		'uk' => __( 'Ukrainian', 'templatic-admin' ),
		'vi' => __( 'Vietnamese', 'templatic-admin' ),
		'zh_cn' => __( 'Simplified Chinese', 'templatic-admin' ),
		'zh_tw' => __( 'Traditional Chinese', 'templatic-admin' ),
	) ;
	?>
	<table id="captcha_settings" class="tmpl-general-settings form-table">
		<tr>
			<td colspan="2"><p class="tevolution_desc"><?php echo wp_kses_post( wp_unslash( __( 'Keep your website spam-free by activating reCAPTCHA challenge to any of the functions or pages below. Please register your website for reCAPTCHA <a title="Get your CAPTCHA API Keys" href="https://www.google.com/recaptcha/admin#list">here</a> and add the keys you will get from there in the fields given below. ', 'templatic-admin' ) ) ); ?></p>
			</td>
		</tr>
		<tbody>
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Site Key', 'templatic-admin' ); ?></th>
				<td>
					<input type="text" value="<?php echo wp_kses_post( wp_unslash( $tmpdata['site_key'] ) ); ?>" size="40" name="site_key">
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Secret Key', 'templatic-admin' ); ?></th>
				<td>
					<input type="text" value="<?php echo wp_kses_post( wp_unslash( $tmpdata['secret'] ) ); ?>" size="40" name="secret">
				</td>
			</tr>
		</tbody>
		<tbody><tr valign="top">
			<th scope="row"><?php echo esc_html__( 'Theme', 'templatic-admin' ); ?></th>
			<td>
				<select id="comments_theme" name="comments_theme">
					<option <?php if ( $tmpdata['comments_theme'] == 'standard' ) { ?>selected="selected" <?php } ?> value="standard"><?php echo esc_html__( 'Standard', 'templatic-admin' ); ?></option>
					<option <?php if ( $tmpdata['comments_theme'] == 'light' ) { ?>selected="selected" <?php } ?> value="light"><?php echo esc_html__( 'Light', 'templatic-admin' ); ?></option>
					<option <?php if ( $tmpdata['comments_theme'] == 'dark' ) { ?>selected="selected" <?php } ?> value="dark"><?php echo esc_html__( 'Dark', 'templatic-admin' ); ?></option>
				</select>
			</td>
		</tr>

		<tr valign="top">
			<th scope="row"><?php echo esc_html__( 'Language', 'templatic-admin' ); ?></th>
			<td>
				<select id="captcha_language" name="captcha_language">
					<?php foreach ( $lang_array as $key => $val ) { ?>
					<option <?php if ( $tmpdata['captcha_language'] == $key ) { ?>selected="selected" <?php } ?> value="<?php echo wp_kses_post( wp_unslash( $key ) ); ?>"><?php echo wp_kses_post( wp_unslash( $val ) ); ?></option>
					<?php }
					?>
				</select>
			</td>
		</tr>
	</tbody>
	<tr>
		<th><label><?php echo esc_html__( 'Enable spam verification for', 'templatic-admin' );?></label></th>
		<td class="captcha_chk">
			<label><input type='checkbox' name="user_verification_page[]" id="user_verification_page" <?php if ( count( (array)$user_verification_page ) > 0 && in_array( 'registration', $user_verification_page ) ) { echo 'checked=checked'; } ?> value="registration"/> <?php echo esc_html__( 'Registration page, Contact Form and Comment form', 'templatic-admin' ); ?></label><div class="clearfix"></div>
			<label><input type='checkbox' name="user_verification_page[]" id="user_verification_page" <?php if ( count( (array)$user_verification_page ) > 0 && in_array( 'submit', $user_verification_page ) ) { echo 'checked=checked'; } ?> value="submit"/> <?php echo esc_html__( 'Submit listing page', 'templatic-admin' ); ?></label><div class="clearfix"></div>
			<label><input type='checkbox' name="user_verification_page[]" id="user_verification_page" <?php if ( count( (array)$user_verification_page ) > 0 && in_array( 'claim', $user_verification_page ) ) { echo 'checked=checked'; } ?> value="claim"/> <?php echo esc_html__( 'Claim Ownership', 'templatic-admin' ); ?></label><div class="clearfix"></div>
			<label><input type='checkbox' name="user_verification_page[]" id="user_verification_page" <?php if ( count( (array)$user_verification_page ) > 0 && in_array( 'emaitofrd', $user_verification_page ) ) { echo 'checked=checked'; } ?> value="emaitofrd"/> <?php echo esc_html__( 'Email to Friend', 'templatic-admin' ); ?></label><div class="clearfix"></div><div class="clearfix"></div>
			<label><input type='checkbox' name="user_verification_page[]" id="user_verification_page" <?php if ( count( (array)$user_verification_page ) > 0 && in_array( 'sendinquiry', $user_verification_page ) ) { echo 'checked=checked'; } ?> value="sendinquiry"/> <?php echo esc_html__( 'Send Inquiry', 'templatic-admin' ); ?></label><div class="clearfix"></div><div class="clearfix"></div>

		</td>
	</tr>
	<tr>
		<td colspan="2">
			<p class="submit" style="clear: both;">
				<input type="submit" name="Submit" class="button button-primary button-hero" value="<?php echo esc_html__( 'Save All Settings', 'templatic-admin' );?>" />
				<input type="hidden" name="settings-submit" value="Y" />
			</p>
		</td>
	</tr>
</table>
<?php
do_action( 'tmpl_after_start_captcha_settings' );
}

/**
 * Function thaat allow tracking site.
 */
function templatic_site_info_tracking_notice() {
	global $wpdb;

	if ( isset( $_POST['tmpl_site_info_tracking_allow'] ) || isset( $_POST['tmpl_site_info_tracking_not_allow'] ) ) {
		/* if true than allow */
		if ( isset( $_POST['tmpl_site_info_tracking_allow'] ) ) {
			update_option( 'tmpl_site_info_tracking', 1 );
		} else {
			update_option( 'tmpl_site_info_tracking', 2 );
		}
	}
	$is_set = get_option( 'tmpl_site_info_tracking' );

	if ( $is_set == '' && ((isset( $_REQUEST['ctab'] ) && ( $_REQUEST['ctab'] == 'custom_fields' || ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'custom_taxonomies_permalink' ) ) && ! isset( $_REQUEST['activated'] ) )  || (isset( $_REQUEST['page'] ) && ( $_REQUEST['page'] == 'custom_setup' || $_REQUEST['page'] == 'templatic_settings' ) )  ) ) {
		?>
		<div id="message" class="update-nag below-h2 tev-cache-msg clearfix" style="width: 60%; height: 40px;">
			<div>
				<form action="" method="post" style="width: 70%; float: left;">

					<p><?php echo wp_kses_post( wp_unslash( __( 'Do you want to allow us to periodically collect anonymous data from your site? <br/>The data will be used to improve plugin performance and ease-of-use. ', 'templatic-admin' ) ) );?>
						<input class="button-primary" type="submit" name="tmpl_site_info_tracking_allow" value="<?php echo esc_html__( 'Allow', 'templatic-admin' );?>" />
						<input class="button-secondary" type="submit" name="tmpl_site_info_tracking_not_allow" value="<?php echo esc_html__( 'Do Not Allow', 'templatic-admin' );?>" />
					</p>
				</form>
			</div>
		</div>

		<?php } ?>

		<?php
}
