<?php
/**
 * Show map on success page.
 *
 * @package WordPress
 * @subpackage Tevolution
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'preview_address_google_map_plugin' ) ) {
	/**
	 * Show pin point on map whitle preview submit form.
	 *
	 * @param integer $latitute 			Address latitute.
	 * @param integer $longitute 			Address longitute.
	 * @param string  $address 				Address.
	 * @param string  $map_type 			Map View.
	 */
	function preview_address_google_map_plugin( $latitute, $longitute, $address, $map_type = 'Road Map' ) {
		if ( $map_type == 'Street map' ) {
			$street_map = $map_type;
		}
		if ( $map_type == 'Satellite Map' ) { $map_type = 'SATELLITE';
		} elseif ( $map_type == 'Terrain Map' ) { $map_type = 'TERRAIN';
		} else { $map_type = 'ROADMAP'; }
		if ( isset( $_REQUEST['pid'] ) ) {
			$taxonomies = get_object_taxonomies( (object) array(
				'post_type' => get_post_type( intval( $_REQUEST['pid'] ) ),
				'public' => true,
				'_builtin' => true,
			) );
			$post_categories = get_the_terms( intval( $_REQUEST['pid'] ) , $taxonomies[0] );
		}
		if ( ! empty( $post_categories ) ) {
			foreach ( $post_categories as $post_category ) {
				if ( $post_category->term_icon ) {
					$term_icon = $post_category->term_icon;
					break;
				}
			}
		}
		$term_icon = (isset( $term_icon ) && $term_icon != '')?$term_icon:apply_filters( 'tmpl_default_map_icon', TEMPL_PLUGIN_URL . 'images/pin.png' );
		if ( isset( $_REQUEST['pid'] ) ) {
			$taxonomies = get_object_taxonomies( (object) array(
				'post_type' => get_post_type( intval( $_REQUEST['pid'] ) ),
				'public' => true,
				'_builtin' => true,
			) );
			$post_categories = get_the_terms( intval( $_REQUEST['pid'] ) , $taxonomies[0] );
		}

		if ( ! empty( $post_categories ) ) {
			foreach ( $post_categories as $post_category ) {
				if ( $post_category->term_icon ) {
					$term_icon = $post_category->term_icon;
					break;
				}
			}
		}

		if ( ! $term_icon ) {
			$term_icon = TEMPL_PLUGIN_URL . 'images/pin.png';
		}

		wp_print_scripts( 'google-maps-apiscript' );
		wp_print_scripts( 'google-clusterig' );

		$google_map_customizer = get_option( 'google_map_customizer' );/* store google map customizer required formate.*/
		?>
		<script type="text/javascript">
			<?php if ( ! is_single() ) {?>
				var script = '<script type="text/javascript" src="//google-maps-' +
				'utility-library-v3.googlecode.com/svn/trunk/infobubble/src/infobubble';
				if ( document.location.search.indexOf( 'compiled' ) !== -1 ) {
					script += '-compiled';
				}
				script += '.js"><' + '/script>';
				document.write(script);
				<?php } ?>
				/* <![CDATA[ */
				var infoBubble;
				var map ;
				function initialize() {

					var geocoder = null;

					var lat = <?php echo wp_kses_post( wp_unslash( $latitute ) );?>;
					var lng = <?php echo wp_kses_post( wp_unslash( $longitute ) );?>;
					var latLng = new google.maps.LatLng(<?php echo wp_kses_post( wp_unslash( $latitute ) );?>, <?php echo wp_kses_post( wp_unslash( $longitute ) );?>);
		//var isDraggable = jQuery(document).width() > 480 ? true : false;
		var myOptions = {
			zoom: 8,
			center: latLng,
			mapTypeId: google.maps.MapTypeId.ROADMAP
		};
		map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
		var styles = [<?php echo wp_kses_post( wp_unslash( substr( $google_map_customizer,0,-1 ) ) );?>];
		map.setOptions({styles: styles});
		var myLatLng = new google.maps.LatLng(<?php echo wp_kses_post( wp_unslash( $latitute ) );?>, <?php echo wp_kses_post( wp_unslash( $longitute ) );?>);
		var marker = new google.maps.Marker({
			map: map,
			position: myLatLng,

			icon: '<?php echo esc_url( $term_icon ); ?>',

			draggable: false
		});

		var contentString = '<?php echo $address;?>';

		infoBubble = new InfoBubble({
			content: contentString,
			maxWidth:210,minWidth:210,minHeight:"auto",padding:0,borderRadius:0,borderWidth:0,borderColor:"none",overflow:"visible",backgroundColor:"#fff",
		});

		google.maps.event.addListener(marker, 'click', function( ) {
			infoBubble.open(map,marker);
		});
		<?php if ( ! is_single() ) {?>
			infoBubble.open(map, marker);
			<?php } ?>
		}
		google.maps.event.addDomListener(window, 'load', initialize);

		/*End*/
		<?php if ( $street_map == 'Street map' ) :?>
		panorama = new google.maps.StreetViewPanorama(document.getElementById( 'map_canvas' ) ) ;
		var sv = new google.maps.StreetViewService();
		sv.getPanoramaByLocation(latLng, 50, processSVData);
	<?php endif;?>




	function processSVData(data, status ) {
		if ( status == google.maps.StreetViewStatus.OK ) {
			var marker = new google.maps.Marker({
				position: data.location.latLng,
				map: map,
				title: data.location.description
			});

			panorama.setPano(data.location.pano);
			panorama.setPov({
				heading: 270,
				pitch: 0
			});
			panorama.setVisible(true );

			google.maps.event.addListener(marker, 'click', function( ) {
				var markerPanoID = data.location.pano;
				/* Set the Pano to use the passed panoID*/
				panorama.setPano(markerPanoID);
				panorama.setPov({
					heading: 270,
					pitch: 0
				});
				panorama.setVisible(true );
			});
		} else {
			alert( 'Street View data not found for this location. ' );
		}
	}

	/* ]]> */
</script>
<div class="map" id="map_canvas" style="width:100%; height:500px;" ></div>
<?php
	}
}// End if().
