<?php /* File - Main Function file */
/*
 * Function Name: yellowpages_theme_setup
 * return: define yellow pages theme support
 */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
define('THEME_DOMAIN','yellowpages');

if( !function_exists('unzip_file')){
	require_once(ABSPATH .'/wp-admin/includes/file.php');
	WP_Filesystem();
}
/* set current theme as child and add Directory theme as parent - it will run only first time when the theme will activated */
if ( get_option( 'is_first_time_install' ) != 1 ){
	
	$filename = get_template_directory() . '/style.css';
	$arr = file( $filename );
	if ( $arr === false ) {
		die( 'Failed to read ' . $filename );
	}
		array_pop( $arr ); // remove last line of */ string

		/* add template name into the file */
		$add_string[] = 'Template: Directory';
		$add_string[] = "\n*/";
		$arr = array_merge( $arr,$add_string );

		// write the new data to the file
		$fp = fopen( $filename, 'w+' );
		fwrite( $fp, implode( '', $arr ) );
		fclose( $fp );

		/* Add templatic directory theme to theme folder */
		$tev_directory = get_stylesheet_directory() . '/Directory.zip';
		$directory_theme = get_theme_root();
		if (file_exists( $tev_directory ) ) {

			if ( file_exists( $tev_directory ) ) {
				unzip_file($tev_directory, $directory_theme);
			}
		}
		update_option( 'is_first_time_install', 1 );
}
if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
	update_option( 'template','Directory' );
}

/*
 * Start easy install
 * Return the plug-in directory path
 */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( ! function_exists( 'get_tmpl_plugin_directory' ) ) {
	function get_tmpl_plugin_directory() {
		return WP_CONTENT_DIR . '/plugins/';
	}
}

/* code to auto extract plugins  START*/
if ( ! function_exists( 'tmpl_plugin_zip_copy' ) ) {
	function tmpl_plugin_zip_copy( $source, $target, $plug_path, $add_msg = 0 ) {
		if ( ! @copy( $source,$target ) ) {
						add_action( 'admin_notices','dir_one_click_install' );
			$errors = error_get_last();
			echo "<span style='color:red;'>" . __( 'COPY ERROR:','templatic-admin' ) . '</span> ' . $errors['type'];
			echo "<br />\n" . $errors['message'];
		} else {
			if ( file_exists( $target ) ) {
				$message = "<span style='color:green;'>" . __( 'File copied from remote!','templatic-admin' ) . '</span><br/>';
				if (  file_exists( $target ) ) {
					unzip_file($target, get_tmpl_plugin_directory());
					unlink( $target );
					$message = __( 'Your .zip file was uploaded and unpacked.','templatic-admin' ) . '<br/>';
				} else {
					
				}
			}
			if ( $add_msg == 1 && strstr( $_SERVER['REQUEST_URI'],'themes.php' ) ) {
								$plug_path1 = 'Tevolution/templatic.php';  // change this to the correct site path
				$plug_path2 = 'Tevolution-Directory/directory.php';  // change this to the correct site path
				$plug_path3 = 'Tevolution-LocationManager/location-manager.php';  // change this to the correct site path

								activate_plugin( $plug_path1 );
								activate_plugin( $plug_path2 );
				activate_plugin( $plug_path3 );
				$_post_type[] = 'post,category,post_tag';
				$location_post_type[] = 'listing,listingcategory,listingtags';
				$post_types = update_option( 'location_post_type',$location_post_type );
			}
		}
	}
}// End if().
add_option('is_first_time_install_yellowpages',1);
/* easy install */
if ( get_option( 'is_first_time_install_yellowpages' ) == 1 && is_admin() && ($pagenow == 'themes.php' || $pagenow == 'theme-install.php') ) 
{
	$tev_zip = get_stylesheet_directory() . '/Tevolution.zip';
	$tev_zip_path = get_stylesheet_directory() . '/Tevolution.zip';

	$prop_zip = get_stylesheet_directory() . '/Tevolution-Directory.zip';
	$prop_zip_path = get_stylesheet_directory() . '/Tevolution-Directory.zip';

	$loc_zip = get_stylesheet_directory() . '/Tevolution-LocationManager.zip';
	$loc_zip_path = get_stylesheet_directory() . '/Tevolution-LocationManager.zip';

	$target_path1 = get_tmpl_plugin_directory() . 'Tevolution.zip';  // change this to the correct site path
	$target_path2 = get_tmpl_plugin_directory() . 'Tevolution-Directory.zip';  // change this to the correct site path
	$target_path3 = get_tmpl_plugin_directory() . 'Tevolution-LocationManager.zip';  // change this to the correct site path

	$plug_path1 = 'Tevolution/templatic.php';  // change this to the correct site path
	$plug_path2 = 'Tevolution-Directory/directory.php';  // change this to the correct site path
	$plug_path3 = 'Tevolution-LocationManager/location-manager.php';  // change this to the correct site path
	if ( is_admin() && $pagenow == 'themes.php' ) { 
		if ( file_exists( $tev_zip_path ) ) {
			tmpl_plugin_zip_copy( $tev_zip, $target_path1, $plug_path1 );
		}
		if ( file_exists( $prop_zip_path ) ) {
			tmpl_plugin_zip_copy( $prop_zip, $target_path2, $plug_path2 );
		}
		if ( file_exists( $loc_zip_path ) ) {
			tmpl_plugin_zip_copy( $loc_zip, $target_path3, $plug_path3, $add_msg = 1 );
		}
	}
	update_option( 'is_first_time_install_yellowpages', 2 );
	remove_action( 'admin_init','include_auto_install_xml_file' );
}
/* End easy install */

global $pagenow,$page;

$page = ( isset( $_REQUEST['page'] ) ) ? $_REQUEST['page'] : '';

if(('themes.php' == $pagenow || strstr( $_SERVER['REQUEST_URI'], 'update.php' ) || strstr( $_SERVER['REQUEST_URI'], 'update-core.php' ) || 'update-core.php' == $pagenow || trim( $page ) == trim( 'tmpl_theme_update' ) ) && file_exists( get_template_directory() . '/wp_theme_update.php' )){

if ( is_admin() && ( 'themes.php' == $pagenow || strstr( $_SERVER['REQUEST_URI'], 'update.php' ) || strstr( $_SERVER['REQUEST_URI'], 'update-core.php' ) || 'update-core.php' == $pagenow || 'post.php' == $pagenow || 'edit.php' == $pagenow || 'admin-ajax.php' == $pagenow || trim( $page ) == trim( 'tmpl_theme_update' ) ) && file_exists( get_template_directory() . '/wp_theme_update.php' ) ) {

	/*&& ! DOING_AJAX*/
	$is_update_page = 0;
	if ( $pagenow == 'update-core.php' ) {
		$is_update_page = 1;
	}
	$dateTimestamp1 = get_option( 'tmpl_update_check_date' );
	if ( trim( $dateTimestamp1 != '' ) ) {
		$dateTimestamp1 = strtotime( $dateTimestamp1 );
	} else {
		update_option( 'tmpl_update_check_date',date( 'Y-m-d H:i:s' ) );
	}
	$dateTimestamp1 = strtotime( get_option( 'tmpl_update_check_date' ) );
	$dateTimestamp2 = strtotime( date( 'Y-m-d H:i:s' ) );
	$interval = abs( $dateTimestamp2 - $dateTimestamp1 );
	$hour_diff = intval( round( $interval / 60 ) / 60 );
	/*if ( $hour_diff > 3 || $is_update_page == 1 ) {*/
		require_once( 'wp-updates-theme.php' );
		new WPUpdatesYellowpagesUpdater( 'https://templatic.com/_data/updates/api/index.php', basename( get_stylesheet_directory() ) );
		if ( $is_update_page == 0 ) {
			update_option( 'tmpl_update_check_date',date( 'Y-m-d H:i:s' ) );
		}
	/*} else {
		require_once( 'wp-updates-theme.php' );
		new WPUpdatesYellowpagesUpdater( '',basename( get_stylesheet_directory() ) );
	}*/
	}
}
add_action( 'after_setup_theme', 'yellowpages_theme_setup',12 );
function yellowpages_theme_setup() {
	$locale = get_locale();
	if ( is_admin() ) {
		if ( file_exists( get_stylesheet_directory() . '/languages/admin-' . $locale . '.mo' ) ) {
			load_textdomain( 'templatic-admin', get_stylesheet_directory() . '/languages/admin-' . $locale . '.mo' );
		} else {
			load_textdomain( 'templatic-admin', get_template_directory() . '/languages/admin-' . $locale . '.mo' );
		}
	} else {
		if ( file_exists( get_stylesheet_directory() . '/languages/' . $locale . '.mo' ) ) {
			load_theme_textdomain( 'templatic', get_stylesheet_directory() . '/languages/' . $locale . '.mo' );
		} else {
			load_textdomain( 'templatic', get_template_directory() . '/languages/' . $locale . '.mo' );
		}
	}

	remove_action( 'init', 'supreme_register_menus' );
	add_theme_support( 'supreme-core-menus', array( // Add core menus.
		'secondary',
		'footer',
		'advance_search_sidebar',
	) );
		add_action( 'admin_init','set_footer_logo_theme_activation',100 );

	/**
	* Widgets action hook
	*/
	//add_action( 'widgets_init', 'yellowpages_widgets_callback',12 );
	/*  Add Action for Customizer Controls Settings Start */
	add_action( 'customize_register',  'yellowpages_register_customizer_settings',100 );
	/*  Add Action for Customizer Controls Settings End */
	/* Register new image sizes. */
	add_action( 'init', 'yellowpages_register_image_sizes' );
	if ( is_plugin_active( 'Templatic-MegaMenu/templatic_megamenu.php' ) ) {
		remove_action( 'megamenu_fullwidget','megamenu_fullwidget',10,2 );
	}
	/*hide listing dummy install strip from backend in plugin section*/
	update_option( 'hide_listing_ajax_notification', true );

	remove_action( 'wp_head','show_user_register_message' );
}
/*
Name : yellowpages_register_image_sizes
Description : Registers additional image size .
*/
function yellowpages_register_image_sizes() {
	add_image_size( 'yellowpages-main-gallery-tab-image', 387, 258, true );
	add_image_size( 'directory_listing-image', 250, 165, true );

}
/*
 * Function Name: set_footer_logo_theme_activation
 * Return: setup templatic footer logo on theme activation
 */
function set_footer_logo_theme_activation() {
	global $pagenow;
	if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' && function_exists( 'supreme_prefix' ) ) {

		$a = get_option( supreme_prefix() . '_theme_settings' );
		$b = array(

		'footer_insert' 					=> '<p class="copyright">&copy; 2020 <a href="//templatic.com/demos/directory"  rel="nofollow">YellowPages</a>. &nbsp;Designed by <a href="//templatic.com" class="footer-logo"  rel="nofollow"><img src="' . get_stylesheet_directory_uri() . '/images/templatic-wordpress-themes.png" alt="WordPress Directory Theme" /></a></p>',
		);

		update_option( supreme_prefix() . '_theme_settings',$b );
	}
}
/*
 * Function Name: get_the_yellowpages_taxonomies
 * Return: Return the categories of listings
 */
function get_the_yellowpages_taxonomies() {
	global $post;
	$taxonomy_category = str_replace( array( ', and', ',' ),array( '', '' ),get_the_taxonomies() );

	$post_type = get_post_type();
	$taxonomies = get_object_taxonomies( (object) array(
		'post_type' => $post_type,
		'public' => true,
		'_builtin' => true,
	) );
	$taxonomy_category = str_replace( CUSTOM_MENU_CAT_LABEL_LISTING . ':',__( '<i class="far fa-edit"></i> ','templatic' ),$taxonomy_category[ $taxonomies[0] ] );
	$taxonomy_category = substr( $taxonomy_category,0,-1 );
	return $taxonomy_category;
}
/*
 * Function Name: get_the_yellowpages_tag
 * Return: Return the tags of listings */

function get_the_yellowpages_tag() {
	global $post;
	$taxonomy_tag = str_replace( array( ',', 'and' ),array( '', '' ),get_the_taxonomies() );
	$post_type = get_post_type();
	$taxonomies = get_object_taxonomies( (object) array(
		'post_type' => $post_type,
		'public' => true,
		'_builtin' => true,
	) );
	$taxonomy_tag = str_replace( CUSTOM_MENU_TAG_TITLE_LISTING . ':',__( '<i class="icon-tags"></i> ','templatic' ), @$taxonomy_tag[ $taxonomies[1] ] );
	$taxonomy_tag = substr( $taxonomy_tag,0,-1 );
	return $taxonomy_tag;
}

/*
 * Function Name: get_the_yellowpages_event_taxonomies
 * Return: Return the categories of events
 */
function get_the_yellowpages_event_taxonomies() {
	global $post;

	$taxonomy_category = str_replace( array( ',', 'and' ),array( '', '' ),get_the_taxonomies() );
	$taxonomy_category = str_replace( CUSTOM_MENU_EVENT_CAT_TITLE . ':',__( '<i class="far fa-edit"></i> ','templatic' ),$taxonomy_category[ CUSTOM_CATEGORY_TYPE_EVENT ] );
	$taxonomy_category = substr( $taxonomy_category,0,-1 );
	return $taxonomy_category;
}

/*
 * Function Name: get_the_yellowpages_event_tag
 * Return: Return the tags of events
 */
function get_the_yellowpages_event_tag() {
	global $post;
	$taxonomy_tag = str_replace( array( ',', 'and' ),array( '', '' ),get_the_taxonomies() );
	$taxonomy_tag = str_replace( CUSTOM_MENU_TAG_TITLE_EVENT . ':',__( '<i class="icon-tags"></i> ','templatic' ), @$taxonomy_tag[ CUSTOM_TAG_TYPE_EVENT ] );
	$taxonomy_tag = substr( $taxonomy_tag,0,-1 );
	return $taxonomy_tag;
}

function get_the_yellowpages_post_taxonomies() {
	global $post;

	$taxonomy_category = str_replace( array( ',', 'and' ),array( '', '' ),get_the_taxonomies() );
	$taxonomy_category = str_replace( 'Categories' . ':',__( '<i class=far fa-edit"></i> ','templatic' ),$taxonomy_category['category'] );
	$taxonomy_category = substr( $taxonomy_category,0,-1 );
	return $taxonomy_category;
}
function get_the_yellowpages_post_tag() {
	global $post;
	$taxonomy_tag = str_replace( array( ',', 'and' ),array( '', '' ),get_the_taxonomies() );
	$taxonomy_tag = str_replace( 'Tags' . ':',__( '<i class="fas fa-tag"></i> ','templatic' ), @$taxonomy_tag['post_tag'] );
	$taxonomy_tag = substr( $taxonomy_tag,0,-1 );
	return $taxonomy_tag;
}



/**
* Function: yellowpages_widgets_callback
* Filter: widgets_init
* Return: add or remove widgets from theme
*/
/*
add_filter('supreme_home_page_banner_title','yellowpages_widgets_callback');
if( !function_exists( 'yellowpages_widgets_callback' ) ){
    function yellowpages_widgets_callback(){
		unregister_sidebar( 'header' );
		return __( 'Home Page Full Map', 'templatic' );
	}
}
*/

/*
Name: yellowpages_templatic_menu
Desc: Add the "Child theme updates" menu in admin section
*/
add_action( 'admin_menu','yellowpages_templatic_menu',20 );
if ( ! function_exists( 'yellowpages_templatic_menu' ) ) {
	function yellowpages_templatic_menu() {
		if ( is_plugin_active( 'Tevolution/templatic.php' ) ) {
			add_submenu_page( 'templatic_system_menu', __( 'Child Theme Update','templatic' ), __( 'Child Theme Update','templatic' ), 'administrator', 'child_tmpl_theme_update', 'child_tmpl_theme_update',27 );
		} else {
			add_submenu_page( 'templatic_menu',  __( 'Child Theme Update','templatic' ), __( 'Child Theme Update','templatic' ), 'administrator', 'child_tmpl_theme_update', 'child_tmpl_theme_update',27 );
		}
	}
}

/* Include file to varify authentication of templatic user */
if ( ! function_exists( 'child_tmpl_theme_update' ) ) {
	function child_tmpl_theme_update() {
		require_once( get_stylesheet_directory() . '/templatic_login.php' );
	}
}

/* Filter to the change the loading image of event calendar */
add_filter( 'calendar_widget_loadin_image','calendar_widget_loadin_image' );
if ( ! function_exists( 'calendar_widget_loadin_image' ) ) {
	function calendar_widget_loadin_image() {
		return get_stylesheet_directory_uri() . '/images/calendar_process.gif';
	}
}
/*
Name : tmpl_comment_form_theme
Desc: return the comment form with design and structure changes
*/
remove_filter( 'comment_form_defaults', 'rating_comment_text_after',200 );
add_filter( 'comment_form_defaults', 'tmpl_comment_form_theme',90 );
function tmpl_comment_form_theme( $arg ) {
	global $post,$wpdb;
	//$arg['comment_field'] = '';
	$post_type_rating = 0;
	$hide_maintaxonomy_rating = get_option( 'hide_maintaxonomy_rating' );
	$rating_title = get_option( 'rating_title' );
	$rating_title_post_type = get_option( 'rating_title' . $post->post_type );
	$rating_product_title = get_option( 'rating_product_title' );
	$taxonomies = get_object_taxonomies( (object) array(
		'post_type' => $post->post_type,
		'public' => true,
		'_builtin' => true,
	) );
	$terms = get_the_terms( $post->ID,$taxonomies[0] );
	$k = 1;
	static $rating_html = '';
	if ( is_plugin_active( 'Templatic-MultiRating/multiple_rating.php' ) ) {
		$rating_html .= '<div class="form_comment_rating_wrap" style="display:none">';
		$tmpdata = get_option( 'templatic_settings' );
		if ( get_post_meta( $post->ID,'average_rating',true ) != '' ) {
			$rating_html .= '<div class="author_rating">';
			if ( is_plugin_active( 'Templatic-MultiRating/multiple_rating.php' ) && function_exists( 'get_single_average_rating_image' ) ) :
				$rating_html .= '<div class="event_rating_row"><span class="single_rating"> <span>Overall Guest Satisfaction</span> ' . get_single_average_rating_image( $post->ID ) . ' </span></div>';
				elseif ( isset( $tmpdata['templatin_rating'] ) && $tmpdata['templatin_rating'] == 'yes' ) :
					$rating_html .= '<div class="listing_rating">
				  <div class="directory_rating_row"><span class="single_rating">' . draw_rating_star_plugin( get_post_average_rating( $post_id ) ) . ' </span></div>
				</div>';
				endif;
				echo '</div>';
		}
		$rating_title_post_type_array = array();
		foreach ( $terms as $term ) {
			if ( ! empty( $rating_title_post_type[ $term->term_id ] ) ) {
				foreach ( $rating_title_post_type[ $term->term_id ] as $key => $value ) {
					if ( $rating_title_post_type[ $term->term_id ][ $key ] != '' && ! in_array( $key,$rating_title_post_type_array ) ) {
						if ( function_exists( 'icl_register_string' ) ) {
							icl_register_string( 'templatic',$value,$value );
							$value = icl_t( 'templatic',$value,$value );
						}
						$rating_html .= '<div id="rate">' . '<span class="rating_desc"> ' . $value . '</span> <input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="0.5" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="1.0" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="1.5" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="2.0" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="2.5" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="3.0" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="3.5" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="4.0" />
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="4.5"/>
															<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="5.0" />
											</div>';
						array_push( $rating_title_post_type_array,$key );
						$k++;
					}
				}
			}

			for ( $i = 0;$i < count( @$rating_title[ $term->term_id ] );$i++ ) {
				if ( $rating_title[ $term->term_id ][ $i ] != '' ) {
					if ( function_exists( 'icl_register_string' ) ) {
						icl_register_string( 'templatic',$rating_title[ $term->term_id ][ $i ],$rating_title[ $term->term_id ][ $i ] );
						$rating_title[ $term->term_id ][ $i ] = icl_t( 'templatic',$rating_title[ $term->term_id ][ $i ],$rating_title[ $term->term_id ][ $i ] );
					}
					$rating_html .= '<div id="rate">' . '<span class="rating_desc"> ' . $rating_title[ $term->term_id ][ $i ] . '</span> <input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="0.5" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="1.0" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="1.5" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="2.0" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="2.5" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="3.0" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="3.5" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="4.0" />
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="4.5"/>
														<input class="star {split:2}" type="radio" name="comment_rating[' . $k . '][]" value="5.0" />
										</div>';
					$k++;
				}
			}
		}// End foreach().
		$rating_html .= '</div>';
		wp_nonce_field( plugin_basename( __FILE__ ), 'comment_rating_display_nonce' );

		$arg['comment_field'] = $rating_html . $arg['comment_field'];
	}// End if().
	return $arg;
}
/*
 Function Name: yellowpages_date_display
 Description : Display Event Date
*/
remove_action( 'event_date_display','event_date_display' );
add_action( 'event_date_display','yellowpages_date_display' );
function yellowpages_date_display() {
	global $post,$htmlvar_name,$tmpl_flds_varname;
	$htmlvar_name_date = $htmlvar_name;
	$post_id = get_the_ID();
	$contenteditable = $is_edit = '';
	if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'edit' ) {
		$is_edit = 1;
		$contenteditable = 'contenteditable="true"';
	}

	$date_formate = get_option( 'date_format' );
	$time_formate = get_option( 'time_format' );
	$starttime = get_post_meta( $post->ID,'st_time',true );
	$endtime = get_post_meta( $post->ID,'end_time',true );

	$st_date = date_i18n( $date_formate,strtotime( get_post_meta( $post->ID,'st_date',true ) ) );
	$end_date = date_i18n( $date_formate,strtotime( get_post_meta( $post->ID,'end_date',true ) ) );
	if ( $starttime != '' ) {
		$st_time = date_i18n( $time_formate,strtotime( $starttime ) );
	}
	if ( $endtime != '' ) {
		$end_time = date_i18n( $time_formate,strtotime( $endtime ) );
	}

	$reg_fees = get_post_meta( $post->ID,'reg_fees',true );

	$address = get_post_meta( $post->ID,'address',true );
	$website = get_post_meta( $post->ID,'website',true );
	$phone = get_post_meta( $post->ID,'phone',true );
	$email = get_post_meta( $post->ID,'email',true );
	echo '<div class="entry-header-custom-left">';
		echo (($tmpl_flds_varname['st_date']) || ($is_edit == 1 && $tmpl_flds_varname['st_date']))? '<p  itemprop="startDate" content="' . date( 'Y-m-d',strtotime( $st_date ) ) . 'T' . $starttime . '" class="date ' . $htmlvar_name_date['event_info']['st_date']['style_class'] . '"><label>' . __( 'Start Date:','templatic' ) . '&nbsp;</strong></label><span id="frontend_date_st_date" class="frontend_st_date frontend_datepicker" ' . $contenteditable . '>' . $st_date . '</span></p>' : '';
		echo (($tmpl_flds_varname['end_date']) || ($is_edit == 1 && $tmpl_flds_varname['end_date']))? '<p itemprop="endDate" content="' . date( 'Y-m-d',strtotime( $end_date ) ) . 'T' . $endtime . '"  class="date ' . $htmlvar_name_date['event_info']['end_date']['style_class'] . '"><label>' . __( 'End Date:','templatic' ) . '&nbsp;</label><span id="frontend_date_end_date" class="frontend_end_date frontend_datepicker" ' . $contenteditable . '>' . $end_date . '</span></p>' : '';

	if ( $is_edit == 1 && $tmpl_flds_varname['st_time'] && $tmpl_flds_varname['end_time'] ) {
		echo '<p class="time"><label>' . __( 'From:','templatic' ) . '&nbsp;</label><span class="event_custom frontend_st_time" ' . $contenteditable . '>' . $st_time . '</span> ' . __( 'To','templatic' ) . ' <span class="event_custom frontend_end_time" ' . $contenteditable . '>' . $end_time . '</span></p>';
	} else {
		echo ($tmpl_flds_varname['st_time'] && $tmpl_flds_varname['end_time'] &&($starttime != '' && $endtime != ''))? '<p class="time"><label>' . __( 'From:','templatic' ) . '&nbsp;</label><span class="event_custom">' . $st_time . ' ' . __( 'To','templatic' ) . ' ' . $end_time . '</span></p>' : '';
	}
		echo (($tmpl_flds_varname['reg_fees'] && $reg_fees) || (is_edit == 1 && $tmpl_flds_varname['reg_fees']))? '<p class="fees ' . $htmlvar_name_date['event_info']['reg_fees']['style_class'] . '"><label>' . __( 'Fees:','templatic' ) . '&nbsp;</label><span class="frontend_reg_fees" ' . $contenteditable . '>' . $reg_fees . '</span></p>' : '';

		echo ((@$htmlvar_name_date['locations_info']['address']) || ($is_edit == 1 && $htmlvar_name_date['locations_info']['address']))? '<p  itemprop="address" class="address ' . @$htmlvar_name_date['locations_info']['address']['style_class'] . '"><label>' . __( 'Location:','templatic' ) . '&nbsp;</label><span id="frontend_address" class="frontend_address" ' . $contenteditable . '>' . $address . '</span></p>' : '';

		echo ((@$htmlvar_name_date['contact_info']['phone']) || ($is_edit == 1 && $htmlvar_name_date['basic_inf']['phone']))? '<p class="phone ' . @$htmlvar_name_date['basic_inf']['phone']['style_class'] . '"><label>' . __( 'Phone:','templatic' ) . '&nbsp;</label><span class="frontend_phone" ' . $contenteditable . '>' . $phone . '</span></p>' : '';

	if ( (@$htmlvar_name_date['contact_info']['website'] && @$website) || ($is_edit == 1 && $htmlvar_name_date['contact_info']['website']) ) {?>	
		 <p class="website <?php echo $htmlvar_name_date['basic_inf']['website']['style_class']; ?>"><label><?php _e( 'Website','templatic' );?>: </label><span><a href="<?php echo $website;?>" id="website" class="frontend_website <?php if ( $is_edit == 1 ) :?>frontend_link<?php endif; ?>"><?php _e( 'Visit Website','templatic' );?></a></span></p>
		<?php
	}
		$prd_id = get_post_meta( $post->ID,'templ_event_ticket',true );
		$booked_tckt_id = get_post_meta( $post->ID,'templ_event_ticket_booked',true );
		$total_tickets = get_post_meta( $prd_id,'_stock',true );
	if ( get_post_meta( $prd_id,'_stock',true ) && is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
		$event_tckt_id = '<a href=' . get_permalink( $prd_id ) . '>' . $total_tickets . '</a>';
		echo "<p class='ticket'>";
		echo $event_tckt_id . ' ';
		_e( 'tickets are available.','templatic' );
		echo '<a href=' . get_permalink( $prd_id ) . " class='bookn_tab button secondary_btn tiny_btn'>" . __( 'Book now','templatic' ) . '</a>';
		echo '</p>';
	}

		$tmpdata = get_option( 'templatic_settings' );
		$special_offer = get_post_meta( $post_id,'proprty_feature',true );
		$video = get_post_meta( $post_id,'video',true );
		$facebook = get_post_meta( $post_id,'facebook',true );
		$google_plus = get_post_meta( $post_id,'google_plus',true );
		$twitter = get_post_meta( $post_id,'twitter',true );

		$post_img = bdw_get_images_plugin( $post_id,'thumb' );
		$post_images = @$post_img[0]['file'];
		$title = urlencode( $post->post_title );
		$url = urlencode( get_permalink( $post_id ) );
		$summary = urlencode( htmlspecialchars( $post->post_content ) );
		$image = $post_images;
		$settings = get_option( 'templatic_settings' );
		?>

		<!--Event Share Link Coding Start -->
		<?php echo '<div class="share_link">';
		?>
			<label><?php _e( 'Share this page','templatic' );?>: </label>
			<span>
			<?php
			if ( ( @$facebook != '' && @$tmpl_flds_varname['facebook']) || ($is_edit == 1 && $tmpl_flds_varname['facebook']) ) {?>
				<a id="facebook" class="frontend_facebook <?php if ( $is_edit == 1 ) :?>frontend_link <?php endif;?>" href="<?php echo $facebook;?>"><i class="fab fa-facebook-f"></i> Facebook</a>
			<?php }?>

						<?php if ( ( @$twitter != '' && @$tmpl_flds_varname['twitter']) || ($is_edit == 1 && $tmpl_flds_varname['twitter']) ) :?>
				<a id="twitter" class="frontend_twitter <?php if ( $is_edit == 1 ) :?>frontend_link <?php endif;?>" href="<?php echo $twitter;?>"><i class="fab fa-twitter"></i> Twitter</a>
			<?php endif;?>

						<?php if ( ($google_plus != '' && $tmpl_flds_varname['google_plus']) || ($is_edit == 1 && $tmpl_flds_varname['google_plus']) ) :?>
				<a id="google_plus" class="frontend_google_plus <?php if ( $is_edit == 1 ) :?>frontend_link <?php endif;?>" href="<?php echo $google_plus;?>"><i class="fab fa-google-plus-g"></i> Google Plus</a>
			<?php endif;
			?>
			</span>
		<?php

					echo '</div>';
		?>
		<!--Event Share Link Coding End -->

			<?php
			do_action( 'directory_display_custom_fields' );
			echo '</div>';

			echo '<div itemprop="location" class="entry-header-custom-right">';
			if ( function_exists( 'bdw_get_images_plugin' ) ) {
				$event_status = get_post_status ( $post_id );
				if ( 'recurring' === $event_status ) {
					$post_id = wp_get_post_parent_id( $post_id );
				}					
				$post_img = bdw_get_images_plugin( $post_id,'yellowpages-main-gallery-tab-image' );
				$postimg_thumbnail = bdw_get_images_plugin( $post_id,'thumbnail' );
				$more_listing_img = bdw_get_images_plugin( $post_id,'tevolution_thumbnail' );
				$thumb_img = @$post_img[0]['file'];
				$attachment_id = @$post_img[0]['id'];
				$image_attributes = wp_get_attachment_image_src( $attachment_id ,'large' ); // returns an array
				$attach_data = get_post( $attachment_id );
				$img_title = $attach_data->post_title;
				$img_alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );

			}

			if ( ! empty( $post_img ) && $is_edit == '' ) :?>
						  <!--Image gallery Section Start -->
						  <div id="event_image_gallery">
							<div  id="slider" class="event_image flexslider">

														<ul class="slides">
									<?php
									$main_post_img = bdw_get_images_plugin( $post_id,'yellowpages-main-gallery-tab-image' );
									foreach ( $main_post_img as $key => $value ) :
										$attachment_id = $value['id'];
										$attach_data = get_post( $attachment_id );
										$image_attributes = wp_get_attachment_image_src( $attachment_id ,'large' ); // returns an array
										$img_title = $attach_data->post_title;

																	?>
										<li>
											<a href="<?php echo $image_attributes['0'];?>" title="<?php echo $img_title; ?>"  class="listing_img" >		
												<img src="<?php echo $value['file'];?>" />
											</a>
										</li>

																			<?php endforeach;?>
									</ul>       

												   </div>

												<?php if ( ! empty( $more_listing_img ) && count( $more_listing_img ) > 1 ) :?>
						<div id="event_image_gallery" >
							<div id="silde_gallery" class="flexslider<?php if ( ! empty( $more_listing_img ) && count( $more_listing_img ) > 11 ) {echo ' slider_padding_class'; }?>">
								 <ul class="more_photos slides">
									<?php foreach ( $more_listing_img as $key => $value ) :
										$attachment_id = $value['id'];
										$attach_data = get_post( $attachment_id );
										$image_attributes = wp_get_attachment_image_src( $attachment_id ,'large' ); // returns an array
										$img_title = $attach_data->post_title;
							?>
										<li>
										 <a href="<?php echo $image_attributes['0'];?>" title="<?php echo $img_title; ?>" >		
											  <img src="<?php echo $value['file'];?>" alt="<?php echo $img_title; ?>"/>
											</a>
									  </li>

																				<?php endforeach;?>
								 </ul>
							</div>
							</div>
						<?php endif;?>
						  </div>
						  <!--Image gallery Section End -->
					<?php endif;

			if ( $is_edit == '1' ) :?>
					 <!-- Frontend edit upload image-->
					<div id="event_image_gallery" class="entry-header-image">
						<!--editing post images -->
						<div id="slider" class="event_image listing-image flexslider frontend_edit_image flex-viewport">
							<ul class="frontend_edit_images_ul slides">
								<?php
								$post_img = bdw_get_images_plugin( $post->ID,'large' );
								if ( ! empty( $post_img ) ) :
									foreach ( $post_img as $key => $value ) :
										echo "<li class='image' data-attachment_id='" . basename( $value['file'] ) . "' data-attachment_src='" . $value['file'] . "'><img src='" . $value['file'] . "' alt='" . $img_title . "' /></li>";
										break;
								endforeach;
								endif;
								?>
							</ul>
							<div id="uploadimage" class="upload button secondary_btn clearfix">
								<span><?php _e( 'Upload Images', 'templatic' ); ?></span>					
							</div>
						</div>

								<div id="frontend_images_gallery_container" class="clearfix flex-viewport">
							<ul class="frontend_images_gallery more_photos slides">
							<?php
							if ( ! empty( $post_img ) ) :
								foreach ( $post_img as $key => $value ) :
									echo "<li class='image' data-attachment_id='" . basename( $value['file'] ) . "' data-attachment_src='" . $value['file'] . "'><img src='" . $value['file'] . "' alt='" . $img_title . "' /><span>
        <a class='delete' title='Delete image' href='#' id='" . $value['id'] . "' ><i class='fas fa-times-circle redcross'></i>";
									echo '</a></span></li>';
							endforeach;
								endif;
							?>
							</ul>
							<input type="hidden" id="fontend_image_gallery" name="fontend_image_gallery" value="<?php echo esc_attr( substr( @$image_gallery,0,-1 ) ); ?>" />		
						</div>
						<span id="forntend_status" class="message_error2 clearfix"></span>
						<!--finsh editing post images -->
					</div>

							<?php endif;
			echo '</div>';
}
/*
 * Function Name: yellowpages_register_customizer_settings
 * Return: add image upload for header and footer image in customizer.
 */
function yellowpages_register_customizer_settings( $wp_customize ) {
	$wp_customize->get_control( 'color_picker_color1' )->label = __( 'Body background','templatic' );
	$wp_customize->get_control( 'color_picker_color2' )->label = __( 'Button bg, Headings, Primary menu bg, Links, Button hover text, Pagination button hover bg, Footer Links hover','templatic' );
	$wp_customize->get_control( 'color_picker_color3' )->label = __( 'Sidebar bg, Pagination button bg, Button hover bg','templatic' );
	$wp_customize->get_control( 'color_picker_color4' )->label = __( 'Page Content Color, Pagination button text','templatic' );
	$wp_customize->get_control( 'color_picker_color5' )->label = __( 'Sub-texts','templatic' );
	$wp_customize->get_control( 'color_picker_color6' )->label = __( 'Content area bg, Form textfield bg, Button text, Pagination button hover text','templatic' );
}
remove_action( 'init','directory_init_function' );
add_action( 'init','yellowpages_init_function' );
function yellowpages_init_function() {
	/*remove detail page image resize*/
	remove_image_size( 'directory-single-image' );
	/* add_image_size( 'directory-single-image', 300, 200, true ); */
	// Register widgetized areas
	if ( function_exists( 'register_sidebar' ) ) {
		register_sidebars( 1,array(
			'id' => 'after_directory_header',
			'name' => __( 'Category Page Below Header','templatic' ),
			'description' => __( 'Widgets placed here appear on the listing category page below the header part.','templatic' ),
			'before_widget' => '<div class="widget">',
			'after_widget' => '</div>',
			'before_title' => '<h3><span>',
			'after_title' => '</span></h3>',
		) );

	}
	remove_filter( 'the_content','view_sharing_buttons' );
	remove_filter( 'the_content', 'view_count' );
}

remove_action( 'init','event_manager_image_sizes' );
add_action( 'init','yellowpages_manager_image_sizes',99 );
function yellowpages_manager_image_sizes() {
	if ( get_option( 'tmpl_added_default_image_sizes' ) != 1 ) {

		if ( get_option( 'medium_size_w' ) != 0 ) {
			update_option( 'medium_size_w',0 );
		}
		if ( get_option( 'medium_size_h' ) != 0 ) {
			update_option( 'medium_size_h',0 );
		}

		if ( get_option( 'large_size_w' ) != 0 ) {
			update_option( 'large_size_w',0 );
		}
		if ( get_option( 'large_size_h' ) != 0 ) {
			update_option( 'large_size_h',0 );
		}

		update_option( 'tmpl_added_default_image_sizes',1 );
	}

	/* add_image_size( 'event-listing-image', 410, 271, true );
    add_image_size( 'event-single-image', 855, 500, true );
	add_image_size( 'event-single-thumb', 60, 60, true ); */

	remove_filter( 'the_content','view_sharing_buttons' );
	remove_filter( 'the_content', 'view_count' );
	remove_action( 'tmpl_before_comments','single_post_categories_tags' );

		/* removed some images */
	remove_image_size( 'clasified-thumb' );
	remove_image_size( 'classified_slider_img_thumb' );
	add_image_size( 'clasified-thumb', 250, 165, true );

	// Register widgetized areas
	if ( function_exists( 'register_sidebar' ) ) {
		register_sidebars( 1,array(
			'id' => 'after_event_header',
			'name' => __( 'Below Event Listing Header','templatic' ),
			'description' => __( 'Widgets placed here appear on the event category page below the header part.','templatic' ),
			'before_widget' => '<div class="widget">',
			'after_widget' => '</div>',
			'before_title' => '<h3><span>',
			'after_title' => '</span></h3>',
		) );

	}
	remove_filter( 'the_content','view_sharing_buttons' );
}
/* templates for addition post type */
add_filter( 'template_include','tmpl_theme_default_templates' );
function tmpl_theme_default_templates( $template ) {

	if ( function_exists( 'tmpl_addon_name' ) ) {
		$addons_posttype = tmpl_addon_name();
	} // End if().

	$current_post_type = get_post_type(); /* get current post type */

	$taxonomies = get_object_taxonomies( (object) array(
		'post_type' => $current_post_type,
		'public' => true,
		'_builtin' => true,
	) );
	if ( $current_post_type == '' ) {
		$current_post_type = 'listing';
	}

	/* called a default template for additional post type */
	if ( function_exists( 'tmpl_wp_is_mobile' ) && ! tmpl_wp_is_mobile() && ! empty( $current_post_type ) && ! array_key_exists( $current_post_type, $addons_posttype ) && ( ! in_array( $current_post_type,array( 'post', 'product', 'attachment' ) )) ) {
		/* template for detail page */
		if ( is_single() && get_post_type() != 'post' && ! file_exists( dirname( __FILE__ ) . '/single-' . $current_post_type . '.php' ) ) {
			if ( file_exists( dirname( __FILE__ ) . '/single-listing.php' ) ) {
				$template = dirname( __FILE__ ) . '/single-listing.php';
			}
		}

		/* template for category/archive/tags page */
		if ( (is_category() || is_tax() || is_post_type_archive()) && ! file_exists( dirname( __FILE__ ) . '/taxonomy-' . $taxonomies[0] . '.php' ) && ! empty( $current_post_type ) && $current_post_type != 'post' ) {
			if ( file_exists( dirname( __FILE__ ) . '/taxonomy-listingcategory.php' ) ) {
				$template = dirname( __FILE__ ) . '/taxonomy-listingcategory.php';
			}
		}

		return $template;
	} else {

		return $template;

	}
}

add_filter( 'tmpl_voucher_title','location_voucher_title' );
function location_voucher_title() {
	return '<h2>' . __( 'Vouchers','templatic' ) . '</h2>';
}

/*
*function to show message after successful registration
*/

add_action( 'wp_head','show_yellopages_user_register_message' );
function show_yellopages_user_register_message() {
	global $post;
	$login_page_id = get_option( 'tevolution_login' );
	$register_page_id = get_option( 'tevolution_register' );
	if ( isset( $_SESSION['successfull_register'] ) && $_SESSION['successfull_register'] != '' ) {
	?>
	<script type="text/javascript" async>
		jQuery( document ).ready(function(){
			jQuery('.header_strip').append('<p class=\"success_msg\"></p>')
			jQuery('.success_msg').html("<?php echo __( 'Thank you for registration! Please check your mail to get your login information.','templatic' );?>");
			jQuery('.success_msg').css('display','block');
			jQuery('.success_msg').css('float','none');
			jQuery('.success_msg').css('margin','auto');
			jQuery('.success_msg').css('max-width','1200px');
			jQuery('.success_msg').css('width','100%');
			jQuery('.success_msg').delay(5000).fadeOut('slow');
		});
	</script>
	<?php
		unset( $_SESSION['successfull_register'] );
	}
}


add_filter( 'tmpl_logreg_links','tmpl_logreg_links_callback' );

function tmpl_logreg_links_callback(){
	return array('secondary');
}

add_action( 'show_secondary_navigation_right', 'yellowpages_show_secondary_navigation_right', 7 );
/**
 * Login link for mega menu.
 */
function yellowpages_show_secondary_navigation_right(){ ?>
	<ul class="mega-menu-login mega">
	<?php 
	global $current_user;

		$login_url = get_tevolution_login_permalink();

		$register_url = get_tevolution_register_permalink();

		$theme_locations = apply_filters( 'tmpl_logreg_links', array( 'primary', 'footer' ) );

		/*Primary Menu location */
		$tmpdata = get_option( 'templatic_settings' );

		/* Check the condition for theme menu location prompt, footer and secondary */
		{
			if ( $current_user->ID ) {
				$loginlink = '<li class="tmpl-login' . ((is_home() ) ? ' ' : '' ) . '"><a href="' . wp_logout_url( home_url() ) . '">' . __( 'Log out', 'templatic' ) . '</a></li>';
			} elseif ( $tmpdata['hide_login_link'] != '1' ) {
				$loginlink = '<li class="tmpl-login' . ((isset( $_REQUEST['ptype'] ) )  && ( $_REQUEST['ptype'] == 'login' )? ' current_page_item' : '' ) . '" ><a data-open="tmpl_reg_login_container" href="javascript:void(0);" onClick="tmpl_login_frm();">' . __( 'Login', 'templatic' ) . '</a></li>';
			}

			if ( isset( $current_user->display_name ) && $current_user->display_name != '' ) {

				$name = $current_user->display_name;
			} else {

				$name = $current_user->user_nicename;

			}

			if ( $current_user->ID ) {
				$reglink = '<li class="tmpl-login user-link' . ((is_author() ) ? ' current-menu-item ' : '' ) . '"><a href="' . get_author_posts_url( $current_user->ID ) . '">' . $name . '</a></li>';
			} else {
				$users_can_register = get_option( 'users_can_register' );
				if ( $users_can_register ) {
					$reglink = '<li class="tmpl-login' . ((isset( $_REQUEST['ptype'] ) )  && ( $_REQUEST['ptype'] == 'register' )? ' current_page_item' : '' ) . '"><a data-open="tmpl_reg_login_container" href="javascript:void(0);" onClick="tmpl_registretion_frm();">' . __( 'Register', 'templatic' ) . '</a></li>';

				}
			}
		}
		echo $loginlink . $reglink ;
	?>
	</ul>
	<?php
}

add_action( 'wp_footer','tmpl_yellowpages_add_scripts' );
function tmpl_yellowpages_add_scripts() {
	?>
	<script type="application/javascript">
		jQuery(document).ready(function(){
			
			
			/* for auto complete result width in instant search */	
			jQuery('.home_page_content .searchform_wdgt .searchpost').focus(function(){
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').hide();
				jQuery('.ui-autocomplete').attr('style','width:'+result_width+'px !important; max-width:'+result_width+'px !important');
				jQuery('.ui-autocomplete li').remove();
			});
			jQuery('.home_page_content .searchform_wdgt .searchpost').bind('keyup',function(){
				jQuery('.ui-autocomplete').hide();
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').attr('style','width:'+result_width+'px !important; max-width:'+result_width+'px !important');
				jQuery('.ui-autocomplete li').remove();
			});

			jQuery('.header_container .searchform_wdgt .searchpost').focus(function(){
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').hide();
				jQuery('.ui-autocomplete').attr('style','width:'+result_width+'px !important; max-width:'+result_width+'px !important');
				jQuery('.ui-autocomplete li').remove();
			});
			jQuery('.header_container .searchform_wdgt .searchpost').bind('keyup',function(){
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').hide();
				jQuery('.ui-autocomplete').attr('style','width:'+result_width+'px !important; max-width:'+result_width+'px !important');
				jQuery('.ui-autocomplete li').remove();
			});
			
			jQuery('.header_container .searchform_wdgt .searchpost').focusout(function(e){ 
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').hide();
				jQuery('.ui-autocomplete li').remove();
				
			});
			
			jQuery('.home_page_content .searchform_wdgt .searchpost').focusout(function(e){
				var result_width = jQuery(this).outerWidth();
				console.log(result_width);
				jQuery('.ui-autocomplete').hide();
				jQuery('.ui-autocomplete li').remove();
				
			});

		});
	</script>
	<?php
}
add_action( 'admin_init','checklogin_page' );
?>
