<?php
if ( ! class_exists( 'BravePop_Mailchimp_Advanced' ) ) {
   
   class BravePop_Mailchimp_Advanced {

      protected $api_key;
      protected $dc;

      function __construct() {
         $braveSettings = get_option('_bravepopup_settings');
         $integrations = $braveSettings && isset($braveSettings['integrations']) ? $braveSettings['integrations'] : array() ;
         $this->api_key = isset($integrations['mailchimp']->api)  ? $integrations['mailchimp']->api  : '';
         $this->dc = substr($this->api_key,strpos($this->api_key,'-')+1); 
      }


      public function get_fields($list_id='',  $apiKey='' ){
         $apiKey  = $apiKey ? $apiKey : $this->api_key;
         $dc      = $apiKey ?substr($apiKey,strpos($apiKey,'-')+1) : $this->dc;
         if(!$apiKey){ return error_log('API KEY MISSING!!!!!');}
         if(!$list_id){ return error_log('Mailchimp List ID MISSING!!!!!'); }
         
         $theData = array('fields'=>array(), 'tags' => array());

         $args = array(
            'headers' => array(
               'Authorization' => 'Basic ' . base64_encode( 'user:'.  $apiKey )
            )
         );
  
         //Fields Request
         // $fieldsResponse = wp_remote_get( 'https://'.$dc.'.api.mailchimp.com/3.0/lists/'.$list_id.'/merge-fields?count=200', $args );
         // //error_log(wp_json_encode($fieldsResponse));
         // if( !is_wp_error( $fieldsResponse ) ) {
         //    $fieldsBody = wp_remote_retrieve_body( $fieldsResponse );
         //    $fieldsData = json_decode( $fieldsBody );
   
         //    if($fieldsData && isset($fieldsData->merge_fields)){
         //       $fields = $fieldsData->merge_fields;
         //       $finalFields = array();
         //       if($fields && is_array($fields)){
         //          foreach ($fields as $key => $field) {
         //             $fieldItem = new stdClass();
         //             $fieldItem->id = isset($field->tag) ? $field->tag : '';
         //             $fieldItem->name = isset($field->name) ? $field->name : '';
         //             $finalFields[] = $fieldItem;
         //          }
         //       }
         //       //error_log(wp_json_encode($finalLists));
         //       $theData['fields'] = $finalFields;
         //    }
         // }


         //Interest Groups Request
         $groupsResponse = wp_remote_get( 'https://'.$dc.'.api.mailchimp.com/3.0/lists/'.$list_id.'/interest-categories?count=300', $args );
         
         if( !is_wp_error( $groupsResponse ) ) {
            $grouspBody = wp_remote_retrieve_body( $groupsResponse );
            $groupsData = json_decode( $grouspBody );

            if($groupsData && isset($groupsData->categories)){
               $groups = $groupsData->categories;
               $finalGroups = array();
               if($groups && is_array($groups) && count($groups) > 0 ){
                  foreach ($groups as $key => $group) {
                     // Get interests from each Group
                     $result = wp_remote_get( 'https://'.$dc.'.api.mailchimp.com/3.0/lists/' . $list_id . '/interest-categories/' . $group->id . '/interests?offset=0&count=500', $args );
                     $res_body = json_decode( wp_remote_retrieve_body( $result ) );
            
                     if ( wp_remote_retrieve_response_code( $result ) == 200 && $res_body->total_items > 0 ) {
                        foreach( $res_body->interests as $interest ) {
                           $finalGroups[] = array('label'=>$group->title . ' - ' . $interest->name, 'value'=> $interest->name.'|'.$interest->id, 'listID'=> $list_id);
                        }
                     }
                  }
               }
               //error_log(wp_json_encode($finalLists));
               $theData['groups'] = $finalGroups;
            }
         }

         return wp_json_encode($theData);
      }

   }

}
?>